// selection.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#ifndef SELECTION_H
#define SELECTION_H

#include <point.h> 	//HASA
#include <handle.h>	//HASA
#include <iostream.h>

class Selection
{
private:
	Handle handle;
	Point point;
	int button;
public:
	Selection() {}
	Selection(const Handle& h, const Point& p, int button = 1);

	Selection(const Selection& s);
	Selection& operator=(const Selection& s);

	Point GetPoint() const { return point; }
	Handle GetHandle() const { return handle; }
	int Button() const { return button; }
	
	friend bool operator==(const Selection& s1, const Selection& s2);

	const Entity* PointsAt() const { return handle.PointsAt(); }
	int Type() const { return handle.Type(); }

	friend ostream& operator<<(ostream& os, const Selection& s);
};


#endif
