// selectionfilter.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //



#include <selectionfilter.h>
#include <algo.h>
//#include <bool.h>

// constructor with depth and criteria code.

//SelectionFilter::SelectionFilter(int crit, int d) : criteria(crit), depth(d) { } 


//==================copy constructor============================

SelectionFilter::SelectionFilter(const SelectionFilter& sf)
{
	entityTypes = sf.entityTypes;
//	depth = sf.depth;
	criteria = sf.criteria;
}


SelectionFilter& SelectionFilter::operator=(const SelectionFilter& sf)
{
	entityTypes = sf.entityTypes;
	//depth = sf.depth;
	criteria = sf.criteria;
	return *this;
}


bool operator==(const SelectionFilter& sf1, const SelectionFilter& sf2)
{
	return (	(sf1.entityTypes == 	sf2.entityTypes) 	&& 
		//	(sf1.depth 	==	sf2.depth)		&&
 			(sf1.criteria	== 	sf2.criteria) 		);
}

void SelectionFilter::Add(int i)
{
	entityTypes.push_back(i);
}

int SelectionFilter::operator[](unsigned int idx) const
{
	if(idx >= entityTypes.size()) return 0;
	return entityTypes[idx];
}

int SelectionFilter::Size() const
{
	return entityTypes.size();
}

bool operator==(int type, const SelectionFilter& sf) // is a type in the list.
{
	vector<int>::const_iterator i = find(sf.entityTypes.begin(),sf.entityTypes.end(),type);
	if(i != sf.entityTypes.end()) return true;
	return false;
}
bool operator==(const SelectionFilter& sf, int type)
{
	int siz = sf.entityTypes.size();
	for(int i = 0 ; i < siz ; i++) if(sf.entityTypes[i] == type )return true;
	return false;
}

ostream& operator<<(ostream& os, const SelectionFilter& sf)
{
	int siz = sf.entityTypes.size();
	os << "size of selection filter = " << siz << '\n';
//	os << "depth = " << sf.depth << '\n';
	os <<  "criteria = " << sf.criteria << '\n';
	for(int i=0;i<siz;i++) os << "SelectionFilter[ " << i << " ] = " << sf.entityTypes[i] << '\n';
	return os;
}
	
