// selectionfilter.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //




#ifndef SELECTIONFILTER_H
#define SELECTIONFILTER_H

#include <iostream.h>
#include <vector>

enum {
	NUM_BUTTONS=7,
	CLOSEST=1,
	PRIORITY
     };

class SelectionFilter
{

private:
	vector<int>entityTypes;
//	int depth;
	int criteria;

public:
	SelectionFilter()  { }
//	SelectionFilter(int crit, int d);	// selection with criteria

	SelectionFilter(const SelectionFilter& sf);
	SelectionFilter& operator=(const SelectionFilter& sf);
	friend bool operator==(const SelectionFilter& sf1, const SelectionFilter& sf2);

	friend bool operator==(int type, const SelectionFilter& sf); // is a type in the list.
	friend bool operator==(const SelectionFilter& sf, int type);

	void SetCriteria(int i) { criteria = i; }

	void Add(int);
	int operator[](unsigned int idx) const;
	int Size() const ;
//	int Depth() const { return depth; }
	int Criteria() const { return criteria;}

	friend ostream& operator<<(ostream&, const SelectionFilter& sf);
};

#endif
