// selectstack.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#ifndef SELECTSTACK_H
#define SELECTSTACK_H

#include <vector>
#include <handle.h>
#include <point.h>
#include <selectionfilter.h>
#include <selection.h>

class CoreException;

// SelectStack types are used to a list of screen selected entities from 
// the VDGLCanvas back to the vdCmdWindow

class SelectStack
{
private:

	vector<Handle> selectedEntities;	// list of selected handles
	Point pickedPoint;			// picked point 
	int button;

public:
	SelectStack() { } 

	SelectStack(int b, const Point& p);
	
	SelectStack(const SelectStack& ss);

	SelectStack& operator=(const SelectStack& ss);

	void Push(const Handle& h);		// load the stack

	Handle Top() const throw (CoreException);	// returns top element

	Handle Pop() throw (CoreException);		// returns top element then pop's it. 

	Selection SelectTop() const throw (CoreException);

	Point GetPoint() const;	// used for extracting the data by vdCmdWindow

	int GetButton() const { return button; }

	int Size() const;			// and this

	Handle operator[](unsigned int idx) const throw (CoreException);	// and this too.

	SelectStack Filter(const SelectionFilter& sf) const;// pass a selection stack through a filter

	Handle TopofType(int type) throw (CoreException);

	friend ostream& operator<<(ostream& os, const SelectStack& ss);

//	double DistanceFromPoint(const Handle& h) const;
};

#endif
