// testgeombank.cpp

// Copyright (C) 1997  Cliff Johnson                                  //
//                                                                         //
// This library is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU Library General Public             //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This library is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// Library General Public License for more details.                        //
//                                                                         //
// You should have received a copy of the GNU Library General Public       //
// License along with this library (see COPYING.LIB); if not, write to the //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //











#include <iostream.h>
#include "point.h"
#include "line.h"
#include "geombank.h"
#include "handle.h"


//double Point::NullDist = .02;
//double Point::NullAngle = .01;

//unsigned long int Handle::nextHandle = 1;


int main(int argc, char** argv)
{

	GeomBank bank;	// Create a bank

// Add points to a bank
	Handle h1 = bank.Create(new Point(),POINT);	
	Handle h2 = bank.Create(new Point(1,1,1),POINT);

// extract points from bank like this:
	Point p1( *(static_cast<const Point*>( h1.PointsAt() ) ) );
	Point p2( *(static_cast<const Point*>( h2.PointsAt() ) ) );

// add a temporary point to a bank...
	Point p3(10,20,30);

// like this:
	Handle h3 = bank.Create(new Point(p3),POINT);

// make a line 
	Handle h4 = bank.Create(new Line(p1,p2),LINE);

// or like this:
	Line l2(p1,p3);
	Handle h5 = bank.Create(new Line(l2),LINE);

// print out the bank
	bank.Print(cout);

// create a line from the handle h4:
	Line l1( *(static_cast<const Line*>( h4.PointsAt() ) ) );

// print out the line
	cout << l1 << '\n';

// remove a handle from the bank
	bank.Destroy(h1);

// print the bank
	cout << '\n';
	bank.Print(cout);

	return 0;
}

