// engineutility.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <engineutility.h>

#include <entity_enum.h>
#include <data_enum.h>

#include <line.h>
#include <circle.h>
#include <segment.h>
#include <arc.h>

double DistanceHandleToPoint(const Handle& h, const Point& point)
{

        switch(h.Type())
        {
        case POINT:
                {
                Point p(*(reinterpret_cast<const Point*>(h.PointsAt())));
                return p.Distance(point);
                }
        case LINE:
                {
                Line l(*(reinterpret_cast<const Line*>(h.PointsAt())));
                return l.Distance(point);
                }
        case SEGMENT:
                {
                Segment s(*(reinterpret_cast<const Segment*>(h.PointsAt())));
                return s.Distance(point);
                }
	
        case CIRCLE:
                {
                Circle c(*(reinterpret_cast<const Circle*>(h.PointsAt())));
                return c.Distance(point);
                }
           case ARC:
		{
                Arc a(*(reinterpret_cast<const Arc*>(h.PointsAt())));
                return a.Distance(point);
		}
        }
        // for yet undetected cases:
        return 1.e+99;
}
