// entitybank.cpp

// Copyright (C) 1997, 1998 Cliff Johnson                                  //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <entitybank.h>		//THIS

#include <locale_enum.h>

#include <algo.h>		//ITO

#include <bankexception.h>

Handle EntityBank::Create(Entity* gx)
{
	Handle hx(gx,PERSISTENT);
	handleArray.push_back(hx);
	return hx;
}

bool EntityBank::Destroy(const Handle& h)
{
	Handle tmp;

	list<Handle>::iterator i;

	i = find(handleArray.begin(),handleArray.end(),h);

	if ( i != handleArray.end() ){

	// delete the memory allocated by the handle 

		tmp = Handle(*i);

	// remove the handle from the list
		handleArray.erase(i++);

	// toast it
		return tmp.Destroy();
	}
	else return false;
}


void EntityBank::Print(ostream& os)
{
	list<Handle>::iterator i;

	for(i=handleArray.begin(); i!=handleArray.end(); i++)
		os << Handle(*i) << '\n';
}

Handle EntityBank::GetHandleFromPointer(const Entity* ptr) const throw (BankException)
{
// find the handle with the input address or throw an exception
// by brute force of course! Actually I'm having trouble figgering
// out the proper operators to add to the handle class to make if work
// with find... So brute force it will be. 

	Handle tmp;

	list<Handle>::const_iterator i;

	for(i=handleArray.begin(); i!=handleArray.end(); i++)
	{
		tmp = Handle(*i);
		if(tmp == ptr)return tmp;
	}
	throw BankException("EntityBank::GetHandleFromPointer() : entity handle not found");
}
