//entitybank.h

// Copyright (C) 1997,1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

// EntityBank is where the data actually "lives" 

// EntityBank keeps track of each entity by 
// assigning a unique 'handle'
// to each entity as it is created. 
//
//
// handle = bank.Create(Entity*)
//
// or, more practically...
//
// handle = bank.Create(new Point(1.,1.),POINT)	// to create an entity
// handle = bank.Create(new Line(Point(), Point(1,1,0) ),LINE);
//
// and 
//
// bool bank.destroy(handle h); 	        // to kill an entity
//
// meanwhile, the handle a has evolved into a class
// among itself, referencing a number and hiding its pointer..
// of course this means that all actual entityetric types are
// derived from a single type... entity
//
// which means that the flow of applications will be
//
// 1 ) Create an entity.
// 2 ) Register that entity with the canvas.
//
//  When the canvas redraws, it has the handle, and thus a pointer for instant access. 
//

#ifndef ENTITYBANK_H
#define ENTITYBANK_H

#include <list.h>  	//HASA

#include <handle.h>  //ITO

class BankException;

class EntityBank
{
private:

	list<Handle> handleArray;

public:
	Handle Create(Entity* gx);
	bool Destroy(const Handle& h);

// diagnostic
	void Print(ostream& os);

	Handle GetHandleFromPointer(const Entity* gx) const throw (BankException);
};


#endif
