// handle.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <handle.h>		//THIS

unsigned int Handle::nextHandle=1;
NameHandler * Handle::nameHandler = new NameHandler();

//***************************************************************

Handle::Handle() // default constructor
{
	entity = NULL;
	handle = 0;
	locale = UNUSED;
}

//***************************************************************

Handle::Handle(const Entity* ptr,Locale l) : locale(l)
{
	// a new entity ...
	if(ptr){
		handle = nextHandle;
		nextHandle++;
		entity = ptr;
		nameHandler->AutoAssignName(*this);
	}
}

//***************************************************************

Handle::Handle(const Handle& h)
{
	entity = h.entity;
	handle = h.handle;
	locale = h.locale;
	name = h.name;
}

//***************************************************************

Handle& Handle::operator=(const Handle& h)
{
	entity = h.entity;
	handle = h.handle;
	locale = h.locale;
	name = h.name;

	return *this;
}

//***************************************************************

// typical friend functions
ostream& operator<<(ostream& os, const Handle& h)
{
	os << "Handle : " << h.handle << " Addr: " << h.entity << " locale = " << (int) h.locale;
	return os;
}

//***************************************************************

bool operator==(const Handle& h1, const Handle& h2) 
{ 
	return h1.handle == h2.handle; 
}

//***************************************************************

bool operator==(unsigned int i, const Handle& h) 
{ 
	return i == h.handle; 
}

//***************************************************************

bool operator==(const Entity* ptr, const Handle& h) 
{ 
	return ptr == h.entity; 
}

//***************************************************************

bool Handle::CleanUp()	 // clean up for local use. 
{
	if(locale == LOCAL){
		delete entity;
		locale = DELETED;
		return true;
	}
	return false; // no de-allocation
}

//***************************************************************

bool Handle::Destroy()	// clean up for global use.
{
	if(handle && locale == PERSISTENT ){
		delete entity;
		handle = 0;		// set handle to 0  so it won't be destroyed twice.
		locale = DELETED;
		return true;
	}
	return false; // no  de-allocation 
}
