// handle.h

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef HANDLE_H
#define HANDLE_H

#include <string>
#include <iostream.h>	//ITO
#include <entity.h>	//HASA
#include <locale_enum.h>

#include <namehandler.h> // HASA
 
class Handle
{
public:
	static unsigned  int nextHandle;
	static NameHandler* nameHandler;
	friend class NameHandler;     

private:
	unsigned  int handle;
	const Entity* entity;
	string name;
	Locale locale;
	
	

public:
	Handle();

	Handle(const Entity* ptr,Locale l = LOCAL);  	// all user construction *MUST* be done with this standard 
			// constructor. This constructor assigns the unique
			// handle number - an unsigned  int - from the static
			// int Handle::nextHandle, and then increments the counter.
			//  Only this constructor assigns a number and increments
			// the counter, and assigns an automatic unique name.
			// the copy constructor simply copies. These constuctors
			// are supplied to make the class work with STL. 

	Handle(const Handle&);
	Handle& operator=(const Handle& h);


	const Entity* PointsAt() const { return entity;}	// allows access to const
								// members of entity types;
	
	bool operator<(const Handle& h) const { return handle < h.handle; }
	bool operator==(unsigned  int h) const { return handle == h; }
	bool operator==(const Entity* ptr) const { return entity == ptr; }

	friend bool operator==(const Handle& h1, const Handle& h2);
	friend bool operator==(unsigned  int i, const Handle& h);
	friend bool operator==(const Entity* ptr, const Handle & h);

	friend ostream& operator<<(ostream& os, const Handle& h);

	unsigned int Value() const { return handle; }

	int Type() const { return entity->Type(); }

	bool CleanUp(); // manage local handles
	bool Destroy(); // manage global handles 
	
	//void Name(const string& s ) { name = s; } // assign a name
	string Name() const { return name; } // get the object name
};

#endif
