// namehandler.cpp

// copyright cliff johnson - 1998  
//
// This is free software. It is licensed under the terms of 
// the GNU GENERAL PUBLIC LICENSE. Read the file COPYING.
// 

#include "namehandler.h"
#include <entity_enum.h>
#include <strstream.h>
#include <handle.h>

enum { UNKNOWN = 0 };
//=============================================================================

NameHandler::NameHandler() 
: unknown("?"), unknown_nextID(1), mangle_nextID(1)
{
	nextID.insert(pair<int, unsigned int> ( POINT  , 1 ) );
	nextID.insert(pair<int, unsigned int> ( LINE   , 1 ) );
	nextID.insert(pair<int, unsigned int> ( CIRCLE , 1 ) );
	nextID.insert(pair<int, unsigned int> ( SEGMENT, 1 ) );
	nextID.insert(pair<int, unsigned int> ( ARC    , 1 ) );
	prefixes.insert(pair<int, string> ( POINT  , string("P")  ));
	prefixes.insert(pair<int, string> ( LINE   , string("L")  ));
	prefixes.insert(pair<int, string> ( CIRCLE , string("C")  ));
	prefixes.insert(pair<int, string> ( SEGMENT, string("S")  ));
	prefixes.insert(pair<int, string> ( ARC    , string("A")  ));

}
//=============================================================================

string NameHandler::AutoAssignName(Handle & h)
{	
	string prefix;
	unsigned int id;
	ostrstream name;
	string theName;

// get the count for the type...
	map<int ,unsigned int, less<int> >::iterator ix = nextID.find(h.Type());
	if(ix == nextID.end())
	{
		id = unknown_nextID;
		unknown_nextID++;
	}
	else
	{
		id = ix->second;
		ix->second++;
	}
// get the prefix
	map<int ,string , less<int> >::iterator iy = prefixes.find(h.Type());
	if(iy == prefixes.end())
	{
		prefix = unknown;
	}
	else
	{
		prefix = iy->second;
	}

// put together the name
	name << '%' << prefix << id << ends;

	theName = string(name.str());

// add the name to the list
// change the name of the handle
// return the name
	return AssignName(h,theName);
}
//=============================================================================

string NameHandler::AssignName(Handle& h, const string & name)
{
	string lname = name; // local copy of name string
// insert the name in the list
// if there is a problem, mangle the name until it works

	set < string > :: iterator ix;
	while((ix = names.find(lname))!=names.end())
	{
		lname = MangleName(lname);
	}
	names.insert(lname);

// change the handle's name
	h.name = lname;

// return the added name
	return lname;

}

//=============================================================================
string NameHandler::MangleName(const string& s)
{
// the simple mangle is just to append #nnn to the end of the name.
// Where nnn is the current value of mangle_nextID, which is then 
// incremented. If the name is already a mangled name, that is, it
// contains a  '#', everything following and including the # will be 
// stripped and the name remangled.
// this should work fine as long as no one uses # as a prefix! don't do that!

	string ls = s; // local copy
	ostrstream iss;

// search for previous mangle character '#'
// strip off everything from the first # onward. 

	size_t pos = ls.find("#");
	if(pos < ls.length()) ls.resize(pos);

// mangle the name
	iss << '#' << mangle_nextID << ends;
	mangle_nextID++;
	ls.append(iss.str());

// return
	return ls;

}

//=============================================================================
void NameHandler::SaveName(Handle& h)
{
// simple remove the '%' character if it is position 0. If not, do nothing.
	if(h.name[0] == '%')
	{
		h.name = string ( h.name.c_str() + 1 ) ;
	}
}

//=============================================================================
bool NameHandler::NameExists(const string& s ) const 
{
		set<string>::const_iterator ix = names.begin();
	while(1)
	{
		if(ix == names.end() ) return false;
		if(*ix == s ) return true;
		ix++;
	}
}

//=============================================================================
