// drawablearc.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <entity_enum.h>
#include <drawablearc.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <point.h>
#include <arc.h>

DrawableArc::DrawableArc(): DrawableEntity(ARC) {}

void DrawableArc::Draw(const Entity* entity,const float& scale) const
{
	if(DrawableEntity::Type()!=ARC)return;

	Arc c = Arc(*(reinterpret_cast<const Arc* >(entity) ) );

        glBegin(GL_LINE_STRIP);
		Point p;	
		double u,du;
		du  = 1./37.;
		for(int i=0; i<=37; i++){
			u = du * i;
			p = c.U(u);
                	glVertex2f(p[0],p[1]);
		}
        glEnd();
}

void DrawableArc::Select(const Entity* entity,const Handle& h,const float& scale) const
{
	if(DrawableEntity::Type()!=ARC)return;

	glLoadName(h.Value());

	Arc c = Arc(*(reinterpret_cast<const Arc* >(entity) ) );
        glBegin(GL_LINE_STRIP);
		Point p;	
		double u,du;
		du  = 1./37.;
		for(int i=0; i<=37; i++){
			u = du * i;
			p = c.U(u);
                	glVertex2f(p[0],p[1]);
		}
        glEnd();
}
