// drawablecircle.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <entity_enum.h>
#include <drawablecircle.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <point.h>
#include <circle.h>

DrawableCircle::DrawableCircle(): DrawableEntity(CIRCLE) {}

void DrawableCircle::Draw(const Entity* entity,const float& scale) const
{
	if(DrawableEntity::Type()!=CIRCLE)return;

// experimental - adaptave drawing
// experimental - figure out how many points are necessary based on the size
// of the circle and the scale. The question is: is it faster to adapt the 
// number of points, or does it take longer to figure out home many points to use. 

// size is size on screen
	float size = scale * 2 * (dynamic_cast<const Circle*>(entity))->Radius();
	int npoints;

// linear 
	if(size < .1)return; // in most human sized cases the maximum zoom will be reached before this happens.
	if(size < 5. ) npoints = 5;
	else if( size < 200.) npoints = (int) (15 + .1 * size);
	else npoints = 35;
// at 5 mm 5 points
// at 200 mm 35 points

        glBegin(GL_LINE_LOOP);
		Point p;	
		double u,du;
		du  = 1./npoints;
		for(int i=0; i<npoints; i++){
			p = (dynamic_cast<const Circle*>(entity))->U(u);
                	glVertex2f(p[0],p[1]);
			u += du;
		}
        glEnd();
}

void DrawableCircle::Select(const Entity* entity,const Handle& h,const float& scale) const
{
	if(DrawableEntity::Type()!=CIRCLE)return;

	glLoadName(h.Value());

        glBegin(GL_LINE_LOOP);
		Point p;	
		double u,du;
		du  = 1./37.;
		for(int i=0; i<37; i++){
			p = (dynamic_cast<const Circle*>(entity))->U(u);
                	glVertex2f(p[0],p[1]);
			u += du;
		}
        glEnd();
}
