// drawablepoint.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //


#include <entity_enum.h>
#include <drawablepoint.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <point.h>

//*************************************************************************

DrawablePoint::DrawablePoint(): DrawableEntity(POINT) {}

//*************************************************************************
void DrawablePoint::Draw(const Entity* entity,const float& scale) const
{
	if(DrawableEntity::Type()!=POINT)return;

	Point p = Point(*(reinterpret_cast<const Point* >(entity) ) );

	glBegin(GL_POINTS);
                glVertex2f(p[0],p[1]);
        glEnd();
}
//*************************************************************************
void DrawablePoint::Select(const Entity* entity, const Handle& handle,const float& scale) const
{
	if(DrawableEntity::Type()!=POINT)return;

        Point p = Point(*(reinterpret_cast<const Point* >(entity) ) );

	glLoadName(handle.Value());

	glBegin(GL_POINTS);
		glVertex2f(p[0],p[1]);
	glEnd();

}
	
