// drawablesegment.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <entity_enum.h>
#include <drawablesegment.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <point.h>
#include <segment.h>

DrawableSegment::DrawableSegment(): DrawableEntity(SEGMENT) {}

void DrawableSegment::Draw(const Entity* entity,const float& scale) const
{
	if(DrawableEntity::Type()!=SEGMENT)return;

	Segment l = Segment(*(reinterpret_cast<const Segment* >(entity) ) );
        Point p0 = l.Origin();
        Point p1 = l.Endpoint();

        glBegin(GL_LINES);
                glVertex2f(p0[0],p0[1]);
                glVertex2f(p1[0],p1[1]);
        glEnd();
}

void DrawableSegment::Select(const Entity* entity,const Handle& h,const float& scale) const
{
	if(DrawableEntity::Type()!=SEGMENT)return;

	glLoadName(h.Value());

	Segment l = Segment(*(reinterpret_cast<const Segment* >(entity) ) );
        Point p0 = l.Origin();
        Point p1 = l.Endpoint();
        glBegin(GL_LINES);
                glVertex2f(p0[0],p0[1]);
                glVertex2f(p1[0],p1[1]);
        glEnd();
}
