// tabledrawables.h

// Copyright (C) 1998  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
// 

#include <tabledrawables.h>
#include <drawableexception.h>
#include <drawablepoint.h>
#include <drawableline.h>
#include <drawablecircle.h>
#include <drawablesegment.h>
#include <drawablearc.h>

#include <drawable_enum.h>


TableDrawables::TableDrawables()
{
// stick all the drawables into a map indexed by strings
drawableMap.insert(pair<int,const DrawableEntity*>(FD_DRAWABLE_POINT,new DrawablePoint()));
drawableMap.insert(pair<int,const DrawableEntity*>(FD_DRAWABLE_LINE,new DrawableLine()));
drawableMap.insert(pair<int,const DrawableEntity*>(FD_DRAWABLE_CIRCLE,new DrawableCircle()));
drawableMap.insert(pair<int,const DrawableEntity*>(FD_DRAWABLE_SEGMENT,new DrawableSegment()));
drawableMap.insert(pair<int,const DrawableEntity*>(FD_DRAWABLE_ARC,new DrawableArc()));
}

TableDrawables::~TableDrawables()
{
	for(map<int, const DrawableEntity*>::iterator ix =drawableMap.begin(); ix != drawableMap.end(); ix++)
		delete (*ix).second;

}

const DrawableEntity* TableDrawables::Drawable(const int& i) const throw (DrawableException)
{
	map<int, const DrawableEntity*>::const_iterator ix = drawableMap.find(i);
	if(ix == drawableMap.end())
		throw DrawableException("TableDrawables::GetDrawable() : cannot find matching drawable");	
	return (*ix).second;
}
