//canvasglstate.cpp


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <canvasglstate.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>

#include <iostream.h>

//---------------------------CanvasGLState::SetOrtho2D(int h, int w)--------------------


CanvasGLState::CanvasGLState(const Point& center, float scale, float ppmm)
{
	viewCenter = center;
	viewScale = scale;
	pixelsPerMillimeter = ppmm;
//	GLStateModified++;
}

void CanvasGLState::SetOrtho2D(int w, int h)
{
        float sw =   static_cast<float>( w ) /  (viewScale * pixelsPerMillimeter) ;
        float sh =   static_cast<float>( h ) /  (viewScale * pixelsPerMillimeter) ;

	// limit sw and sh to MAXVIEWDIMENSION
	float maxdim;
	if(sw > sh) maxdim = sw;
	else maxdim = sh;

	if(maxdim > MAXVIEWDIMENSION )
	{
		sw = sw * (static_cast<float>(MAXVIEWDIMENSION) / maxdim);
		sh = sh * (static_cast<float>(MAXVIEWDIMENSION)/ maxdim);
	}
		
//	glMatrixMode(GL_PROJECTION);
//      glLoadIdentity();
	gluOrtho2D(	viewCenter[0]-sw/2., 
		   	viewCenter[0]+sw/2.,
			viewCenter[1]-sh/2.,
			viewCenter[1]+sh/2.);
//	glMatrixMode(GL_MODELVIEW);
}

//---------------------------CanvasGLState::SetScale()--------------------

void CanvasGLState::SetScale(float s)
{
	if(s> .001)if(s<10000.)viewScale = s;  // refuse unreasonable values
}


//---------------------------CanvasGLState::SetPPMM(float ppmm)--------------------

void CanvasGLState::SetPPMM(float ppmm)
{
	if(ppmm > 1) if(ppmm < 10)pixelsPerMillimeter=ppmm; 	// refuse unreasonable values
}


//---------------------------CanvasGLState::SetSenter(const Point& p)--------------------

void CanvasGLState::SetCenter(const Point& p)
{
	if(Distance(Point(),p)<10000.) viewCenter = p; 	// maximum distance of center from origin
}

Point CanvasGLState::GetCoord(int x,int y,int w, int h)
{
// convert to real coordinates of pick relative to center
        float rx =   static_cast<float>( x - w/2 ) /  (viewScale * pixelsPerMillimeter) ;
        float ry =   static_cast<float>( y - h/2 ) /  (viewScale * pixelsPerMillimeter) ;

	return Point(viewCenter + Point(rx,-ry));
}


//=====================CanvasGLState::ZoomIn===========================

void CanvasGLState::ZoomIn(const Point& p1, const Point& p2, int w, int h) 
{
	// get window dimensions in real coordinates
        float sw =   static_cast<float>( w ) /  (viewScale * pixelsPerMillimeter) ;
        float sh =   static_cast<float>( h ) /  (viewScale * pixelsPerMillimeter) ;

	// calculate ratio's of h/w
	float dx = fabs(p2[0]-p1[0]);
	float dy = fabs(p2[1]-p1[1]);

	float zoomFactor;
	if(dy / dx  > sh / sw )		// height dominates
	{ 						
		 zoomFactor  = sh / dy; 
	} 
	else				// width dominates
	{
		zoomFactor = sw / dx ;
	}

	// limit scale change to a factor of MAXZOOMFACTOR
	if ( zoomFactor > MAXZOOMFACTOR) zoomFactor = MAXZOOMFACTOR;

	viewScale = viewScale * zoomFactor;
	
	// new center point is half way between p1 and p2

	viewCenter =  p1 +  (( p2 - p1 ) * .5  );
}


//=====================CanvasGLState::ZoomOut===========================

void CanvasGLState::ZoomOut(const Point& p1, const Point& p2, int w, int h)
{
	// get window dimensions in real coordinates
        float sw =   static_cast<float>( w ) /  (viewScale * pixelsPerMillimeter) ;
        float sh =   static_cast<float>( h ) /  (viewScale * pixelsPerMillimeter) ;

	// calculate ratio's of h/w
	float dx = fabs(p2[0]-p1[0]);
	float dy = fabs(p2[1]-p1[1]);
	float zoomFactor;

	if(dy / dx  > sh / sw )		// width dominates
	{ 						
		zoomFactor = dx / sw; 
	} 
	else				// height dominates
	{
		zoomFactor = dy / sh;
	}
	// limit scale change to a factor of 1/MAXZOOMFACTOR
	float mz = MAXZOOMFACTOR;
	if ( zoomFactor < 1./mz) zoomFactor = 1./mz;

	viewScale = viewScale * zoomFactor;
	
	// calculate new center point -
	// current point moves to halfway between p1 and p2

	Point px =  p1 +  (( p2 - p1 ) * .5  );
	Point vx = (px - viewCenter) * (1/zoomFactor);
	viewCenter = viewCenter - vx;
}
