//canvasglstate.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
// 
// 
// 
// 
// 
// ppmm, or pixels per millimeter of screen, should be set as best you can
// figure in the constructor by the owner object, most likely the vdglcanvas. 
// my monitor is about 3.8 ppmm. 
// 
// scale is defined as millimeters of screen per millimeter of object drawn. 
// So at scale = 1 an object is drawn true size. At scale 2 twice as much screen
// is used etc. 
// 

#ifndef CANVASGLSTATE_H
#define CANVASGLSTATE_H

#include <point.h>	//HASA

//++++++++++++++++++++++++ CanvasGLState +++++++++++++++++++++
class CanvasGLState
{
	enum {MAXZOOMFACTOR = 8, 		// max change in zoom
	      MAXVIEWDIMENSION = 10000 };	// max view dimension

private:
	Point viewCenter;
	float viewScale;
	float pixelsPerMillimeter;	// pixels per millimeter at viewScale = 1.0 

//public: ***everyfuckingthing is private***

	CanvasGLState(const Point& center, float scale, float ppmm);
	void SetOrtho2D(int w, int h);

	void SetScale(float s);
	void SetPPMM(float ppmm);
	void SetCenter(const Point& p);

	float GetScale() const { return viewScale; }
	float GetPPMM() const { return pixelsPerMillimeter; }
	Point GetCenter() const { return viewCenter;}

	friend class VDGLCanvas;	// directly manipulable by VDGLCanvas
	Point GetCoord(int x, int y, int w, int h); // return the real world 
						    //coordinates  at screen x,y
// adjust view for zoom in/out on extreme points
	void ZoomIn(const Point& p1, const Point& p2, int w, int h); 
	void ZoomOut(const Point& p1, const Point& p2, int w, int h);

};

#endif
