// functionmapbehavior.cpp


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include "vdapp_enum.h"
#include "functionmapbehavior.h"
#include <iostream.h>
#include <menuhandler_enum.h>


// the behavior is defined:
// if one of the function map buttons is selected it remains selected until:
// another button is selected  (call to Selected()) or 'GO' or 'Cancel' is 
// selected (call to Clear)

FunctionMapBehavior::FunctionMapBehavior()
{
	selectedbutton=-1;
}

void FunctionMapBehavior::Clear(vCmdWindow* cmdwindow)
{
	if(selectedbutton>=0){
		cmdwindow->SetValue(selectedbutton,0,Value);
		selectedbutton=-1;
		cmdwindow->SetValue(FD_DELETE,0,Value);
		cmdwindow->SetValue(FD_QUERY,0,Value);
	}
}

// keep the button pressed.. unselect only with GO or CANCEL

void FunctionMapBehavior::Selected(vCmdWindow* cmdwindow,int id)
{
	if (selectedbutton != id){
		cmdwindow->SetValue(selectedbutton,0,Value);
		selectedbutton=id;
	}
	else cmdwindow->SetValue(selectedbutton,1,Value);
}
