// pointstack.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <pointstack.h>

void PointStack::Push(const Point& p)
{
	ps.push_back(p);
}

Point PointStack::Pop()
{
	if(ps.size() != 0 ){
		Point p = ps.back();
		ps.pop_back();
		return Point(p);
	}
	return Point();
}

bool PointStack::IsEmpty()
{
	return ps.size() == 0;
}

void PointStack::Clear()
{
	while (ps.size() != 0 )ps.pop_back();
}
