// typemaskbehavior.cpp


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

//#include <bool.h>
#include <vdapp_enum.h>
#include <entity_enum.h>
#include <typemaskbehavior.h>

//======================================================================================

TypeMaskBehavior::TypeMaskBehavior(vCmdWindow* v) 
: cmdWindow(v)
{

//#include <cmdarray.cpp_>
//#include <valuearray.cpp_>

	array.push_back(Triple(false,POINT,m_Point));
	array.push_back(Triple(false,LINE,m_Line));
	array.push_back(Triple(false,CIRCLE,m_Circle));
	array.push_back(Triple(false,SEGMENT,m_Segment));
	array.push_back(Triple(false,ARC,m_Arc));
	array.push_back(Triple(false,ELLIPSE,m_Ellipse));
	array.push_back(Triple(false,CURVE,m_Curve));

	
//      for(int i=0;i<NUMBUTTONS;i++)statusArray[i]=false;
        sumMode = false;
}

//======================================================================================
void TypeMaskBehavior::Clear()
{
	for(vector<Triple>::iterator i = array.begin(); i != array.end(); i++)
	{
		cmdWindow->SetValue(i->cmd, 0, Value);
		i->status=false;
	}
}

//======================================================================================
void TypeMaskBehavior::All()
{
	for(vector<Triple>::iterator i = array.begin(); i != array.end(); i++)
	{
		cmdWindow->SetValue(i->cmd, 1, Value);
		i->status = true;
	}
}

//======================================================================================
void TypeMaskBehavior::SetSumMode(int mode)
{
	if(mode)sumMode=true ;
	else sumMode = false;

// make sure the button shows the correct value
	cmdWindow->SetValue(m_Sum,sumMode,Value);
}

//======================================================================================
void TypeMaskBehavior::Selected(int id,bool usevaluemask )
{
	int key;

	if(!sumMode)Clear();

	for( vector<Triple>::iterator ix = array.begin(); ix != array.end(); ix++)
	{
		if(usevaluemask) key = ix->value;
		else key = ix->cmd;

		if( key == id) 
		{
			if(ix->status) ix->status=false;
			else ix->status=true;
		}

		cmdWindow->SetValue(ix->cmd, ix->status, Value);
	}
}
//
//	for(int i=0;i<NUMBUTTONS;i++){
//
//		key = cmdArray[i];	             // copy the key from the command array
//		if(usevaluemask)key = valueArray[i]; // or maybe from the vaule array	
//
//		if(key == id){
//			if(statusArray[i])statusArray[i]=false;	//negate the value of the status array
//			else statusArray[i] = true;
//		}
//		cmdWindow->SetValue(cmdArray[i],statusArray[i],Value);
//	}
//}

//======================================================================================
void TypeMaskBehavior::SetFilter(const SelectionFilter& sf)
{
	Clear();

	SetSumMode(true);
	for(int i=0; i < sf.Size() ; i++)Selected(sf[i],true); // set according to value mask-
								 // entity values from entity_enum.h
								 // these are the currency of the
								 // SelectionFilter
	SetSumMode(false);
}
//======================================================================================
	
SelectionFilter TypeMaskBehavior::GetFilter() const
{
	SelectionFilter sf;

	for( vector<Triple>::const_iterator ix = array.begin(); ix != array.end(); ix++)
		if(ix->status)sf.Add(ix->value);
		

//	for(int i=0; i< NUMBUTTONS; i++){
//		
//		if(statusArray[i]){
//			sf.Add(valueArray[i]);
//		}
//	}

	return sf;
}
//======================================================================================
