// typemaskbehavior.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef TYPEMASKBEHAVIOR_H
#define TYPEMASKBEHAVIOR_H

#include <v/vcmdwin.h> 		//ITO
//#include <bool.h>

#include <selectionfilter.h>

// The TypeMaskButtonBehavior class is local to the command Window, which
// creates and contains 1 object of this type.
//
//  This class manages the type selection menu - imposing the 
//  selection behavior according to SUM, CLEAR, ALL and entity buttons.
//

enum{
	NUMBUTTONS = 7
};
	
struct Triple 
{
	bool status;
	int value;
	int cmd;

	Triple(const bool& b ,const int& i1 ,const int& i2 ) : status(b), value(i1), cmd(i2) {}

	//bool Status() const { return status; }
	//void Status(const bool& b) { status = b; }
	//int Value() const { return value; }
	//int Cmd() const { return cmd; } 
	
};

class TypeMaskBehavior 
{
private:
	vector <Triple> array;
	bool sumMode;
	vCmdWindow* cmdWindow;
public:
	TypeMaskBehavior(vCmdWindow*);
	void Clear();
	void All();
	void SetSumMode(int mode);
	void Selected(int id,bool usevaluemask = FALSE);
	void SetFilter(const SelectionFilter& sf);
	SelectionFilter GetFilter() const;
};
#endif
