// vdapp.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <vdapp.h>
#include <vdcmdwin.h>

//=========================>>> vdApp::NewAppWin <<<======================
  vWindow* vdApp::NewAppWin(vWindow* win, char* name, int w, int h,
    vAppWinInfo* winInfo)
  {
    vWindow* thisWin = win;             // local copy to use
    vAppWinInfo* awinfo = winInfo;
    char *myname = name;                // local copy

    if (!name || !*name)
        myname = "Example";            // make up a name
        
    // The UserDebug macros are useful for tracking what is going on.
    // This shows we're building a window.

    UserDebug1(Build,"vdApp::NewAppWin(%s)\n",myname);

    // You may instantiate an instance of the window outside of
    // NewAppWin, or allow NewAppWin to create the instance.

    if (!thisWin) thisWin = new vdCmdWindow(myname, w, h);

    // The vAppWinInfo class is meant to serve as a database used by the
    // vdApp controller. If you use this feature, you will probably
    // derive your own myAppWinInfo class from vAppWinInfo. The instance
    // of vAppWinInfo created here will be automatically deleted when
    // this window instance is closed through CloseAppWin.

    if (!awinfo)        // Did caller provide an appinfo?
        awinfo = new vAppWinInfo(myname);

    // After you have created an instance of the window and an instance
    // of the AppWinInfo, you MUST call the base vApp::NewAppWin method.
    // You won't need to explicitly keep track of the pointer to
    // each new window -- unless it has to interact with other windows.
    // If that is the case, then you can use your derived vAppWinInfo
    // to coordinate the interaction.

    return vApp::NewAppWin(thisWin,name,w,h,awinfo);
  }

//===========================>>> vdApp::Exit <<<=========================
  void vdApp::Exit(void)
  {
    // This can be called to close all windows. If the app needs to do
    // something special, it can. Otherwise, it can call the general
    // vApp::Exit method, which will perform appropriate calls the the
    // specialized vdApp::CloseAppWin.

    UserDebug(Build,"vdApp::Exit()\n");

    vApp::Exit();       // easy default behavior
  }

//======================>>> vdApp::CloseAppWin <<<=======================
  int vdApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed. The app can do whatever it needs to to close down the
    // data associated with this window. (It is invoked explicitly by
    // you in response to a Close menu pick, for example, or when the
    // user clicks the close button. It can also be called by vApp::Exit().
    // After this method cleans up, it can then call the superclass
    // vApp::CloseAppWin to unregister and close this window. Note that
    // the win gives a handle that can be used with vApp::getAppWinInfo
    // to retrieve the AppWinInfo class.

    UserDebug(Build,"vdApp::CloseAppWin()\n");

    // Code to handle close of window (such as saving/closing
    // a file) would go here...

    return vApp::CloseAppWin(win);   // Unregister and close the window.
  }

//=====================>>> vdApp::AppCommand <<<=========================
  void vdApp::AppCommand(vWindow* win, ItemVal id, ItemVal val,
    CmdType cType)
  {
    // Any commands not processed by the window WindowCommand
    // method will be passed to here for default treatment.

    UserDebug1(Build,"vdApp::AppCmd(ID: %d)\n",id);
    vApp::AppCommand(win, id, val, cType);
  }

//=======================>>> vdApp::KeyIn <<<============================
  void vdApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    // Any key strokes not processed by the window will be passed
    // along to here for default treatment.

    vApp::KeyIn(win, key, shift);
  }

//========================================================================

  static vdApp vd_App("vdApp");  // The single instance of the app

//===========================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
    (void) theApp->NewAppWin(0, "FREEdraft 0.3", 850, 480, 0);

    return 0; // if everything is groovy.
  }
