// vdapp.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef VDAPP_H                // Standard technique for avoiding
#define VDAPP_H                // problems with multiple #includes

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include <v/vapp.h>     // We are derived from vApp
#include <v/vawinfo.h>  // Need for app info

    class vdApp : public vApp
      {
        friend int AppMain(int, char**); // allow AppMain access

      public:     

        vdApp(char* name) : vApp(name) {}
        virtual ~vdApp() {}

        // Routines from vApp that are normally overridden

        virtual vWindow* NewAppWin(vWindow* win, char* name, int w, int h, vAppWinInfo* winInfo);
        virtual void Exit(void);
        virtual int CloseAppWin(vWindow* win);
        virtual void AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType);
        virtual void KeyIn(vWindow* win, vKey key, unsigned int shift);

        // New routines for this particular app go here

      protected:        //------------------------------------- protected

      private:          //--------------------------------------- private

      };
#endif
