// vdcmdwin.cpp

// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING.LIB); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#include <iostream.h>
#include <v/vnotice.h>  // so we can use notice
#include <v/vkeys.h>    // to map keys
#include <v/vutil.h>    // for utilities
#include <v/vicon.h>
#include <v/vfilesel.h> // for file select

#include <vdcmdwin.h>            // our header file
#include <vdapp_enum.h>
#include <data_enum.h>
#include <entity_enum.h>
#include <saverecallmenu_enum.h>
#include <attrib_enum.h>
//#include <entitymenu_enum.h>

#include <attributes.h>		//ITO
#include <handle.h>		//ITO
#include <point.h>		//ITO
#include <line.h>		//ITO
#include <canvasregister.h> 	//ITO
#include <selection.h>
//#include <menuhandler.h>

#include <geommenuhandler.h>
#include <nomenuhandler.h>
#include <saverecallmenuhandler.h>
#include <measurementmenuhandler.h>

#include <selectionfilter.h>

#include <coreexception.h>

#include <tabledrawables.h>

// main menu definitions
#include <vdmainmenu.cpp_>	// sub classed

// entity selection / modifier menu definitions
#include <vdtypemaskbar.cpp_>	// sub classed

// function menu definitions
#include <vdfunctionmenu.cpp_>	// sub classed




static vStatus InputStatusBar[] = 
{
  {"                                                  ",m_InputStatusPane,CA_None,isSens,0},
  {0,0,0,0,0}
};

  vdCmdWindow::vdCmdWindow(char* name, int width, int height) :
    	vCmdWindow(name, width, height)
//	inputString(),  ... moved to menuhandler 
  {
	currentColor =  FD_WHITE;
   currentLineStyle = FD_LINESTYLE_SOLID;
	currentThick = FD_LINETHICK_NORMAL;
	currentPointSize = FD_POINTSIZE_NORMAL;
	currentLayer = 1;
	currentFileName = string();
	
    // constructor for vdCmdWindow. 

    snapResolution = DEFAULT_SNAP_RESOLUTION;

    UserDebug1(Constructor,"vdCmdWindow::vdCmdWindow(%s) Constructor\n",name)

    // Create and add the standard Menu Bar to this window
    vdMainMenu = new vMenuPane(StandardMenu);
    AddPane(vdMainMenu);

    // Create and add our Canvas pane to this window

	drawregister = new CanvasRegister();

	vdglcanvas = new VDGLCanvas(drawregister);
	
	AddPane(vdglcanvas);

 // Create and add the typemask command pane
    typeMaskCmdPane = new vCommandPane(TypeMaskCommandBar);
    AddPane(typeMaskCmdPane);

// function menu 
    functionMenuCmdPane = new vCommandPane(FunctionMenuCommandBar);
    AddPane(functionMenuCmdPane);

// input status pane
    inputStatusPane = new vStatusPane(InputStatusBar);
    AddPane(inputStatusPane);

    // FINALLY, after all the panes have been constructed and
    // added, we must show the window!

    ShowWindow();

// Create the entity bank

	bank = new EntityBank();

// initialize the drawables
	tableDrawables = new TableDrawables();

// Create the menu handler;

	menuHandler = new GeomMenuHandler(this,-1);

// create typemaskbehavior
	typeMaskBehavior = new TypeMaskBehavior(this);

// create ModiferBehavior
	modifierBehavior = new ModifierBehavior();
// create FunctionMapBehavior

        functionMapBehavior = new FunctionMapBehavior();

}

//=====================>>> vdCmdWindow::~vdCmdWindow <<<====================
  vdCmdWindow::~vdCmdWindow()
  {
    UserDebug(Destructor,"vdCmdWindow::~vdCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.
    delete modifierBehavior;
// create FunctionMapBehavior

    delete functionMapBehavior;
 
    delete typeMaskBehavior;
    delete menuHandler;
    delete tableDrawables;
    delete bank;
    delete functionMenuCmdPane;
    delete typeMaskCmdPane;
    delete vdglcanvas;
    delete vdMainMenu;
    delete inputStatusPane;
  }

//************************>>> vdCmdWindow::KeyIn <<<********************************************
  void vdCmdWindow::KeyIn(vKey keysym, unsigned int shift)
  {
//cout << "void vdCmdWindow::KeyIn( " << (unsigned int) keysym << " , " << shift << " ) " << endl;

// intersept some codes for direct action by viewer
	switch(keysym)
	{
//	case KB_CenterView:
        case KB_ZoomUp:
        case KB_ZoomDown:
        case KB_LeftArrow:
        case KB_UpArrow:
        case KB_RightArrow:
        case KB_DownArrow:
		{
		vdglcanvas->ModifyView(keysym);
		break;
		}
	case KB_SpaceBar:
		{
			menuHandler->LoadModifier(FD_KEYBOARD);
			break;
		}
	}

//cout << "KeyIn--> " << endl;
  }

//====================>>> vdCmdWindow::WindowCommand <<<===================
  void vdCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {

// calling sub-handler functions makes this much easier to read!

	switch (id)                 // The main switch to handle commands
	{

// File Menu commands ------------------------------------

        case M_New:
        case M_Open:            // This demos vFileSelect dialog
        case M_Save:            // This would usually save a file
        case M_SaveAs:          // Save to a specified name
        case M_SetDebug:
        case M_Exit:            // Standard exit command
	  	{
		FileMenuCommand(id, val, cType);
		break;
	  	}	

// Attribute Menu Commands ----------------------------------


	case m_ColorAttribute:
	case m_LayerAttribute:
	case m_LineTypeAttribute:
		{
		AttributeMenuCommand(id, val, cType);
		break;
		}


// View Menu Commands ----------------------------------

	case m_ViewReset:
	case m_ViewScale:
		{
		ViewMenuCommand(id, val, cType);
		break;
		}

// module Menu Commands -------------------------------
	case m_GeometryModule:
		{
		delete menuHandler;
		menuHandler = new GeomMenuHandler(this, -1);
		break;
		}

	case m_MeasurementModule:
		{
		delete menuHandler;
		menuHandler = new MeasurementMenuHandler(this, -1);
		break;
		}
		

	case m_NoModule:
		{
		delete menuHandler;
		menuHandler = new NoMenuHandler(this, -1);
		break;
		}

// Action button bar commands ----------------------------------
	case m_ClearMask:
	case m_Wildcard:	
        case m_Sum:		   
        case m_Point:		
	case m_Line:		
	case m_Circle:		
	case m_Segment:
	case m_Arc:
	case m_Ellipse:		
	case m_Curve:		
	case m_Group:		
	case m_Pan:
	case m_CView:
	case m_ZoomIn:
	case m_ZoomOut:
	case m_MaxZoom:
		{
		ButtonBarCommand(id, val, cType);
		break;
		}
//Modifier buttons
	case FD_ENDPOINT:
	case FD_MIDPOINT:
	case FD_CENTER:
	case FD_INTERSECTION:
	case FD_SUPPORT:
	case FD_KEYBOARD:
		{
		menuHandler->LoadModifier(id);
		break;
		}
//Function Menus-------------------------------------------------

	case MENUBUTTON00:
	case MENUBUTTON01:
	case MENUBUTTON10:
	case MENUBUTTON11:
	case MENUBUTTON20:
	case MENUBUTTON21:
	case MENUBUTTON30:
	case MENUBUTTON31:
	case MENUBUTTON40:
	case MENUBUTTON41:
	case MENUBUTTON50:
	case MENUBUTTON51:
	case MENUBUTTON60:
	case MENUBUTTON61:
	case MENUBUTTON70:
	case MENUBUTTON71:
	case MENUBUTTON80:
	case MENUBUTTON81:
	case MENUBUTTON90:
	case MENUBUTTON91:
	case FD_CANCEL:
	case FD_CONFIRM:
	case FD_DELETE:
	case FD_QUERY:
	case FD_COLORBUTTON:
		{
		menuHandler->MenuCommand(id);
		break;
		}

        default:   // route unhandled commands up to superclass
		{
            	vCmdWindow::WindowCommand(id, val, cType);
            	break;
          	}
	}
}

//==============vdCmdWindow::FileMenuCommands=================================================


void vdCmdWindow::FileMenuCommand(ItemVal id, ItemVal val, CmdType cType)
{
	vNoticeDialog note(this);

// default file filters for save recall
        static char* defaultSaveRecallFilter[] = { "*.fdf", "*", 0 };
	int fI = 0;			// Filter index
	char name[100] = ""; // initial name string is null

	char * filedir = getenv("FD_FILES"); 

cerr << "filedir = " << filedir << endl;
	switch(id)
	{

	case M_New:             // For this example, we will open a
		{                     // new window using our NewAppWin.
			(void)theApp->NewAppWin(0,"",250, 100);
			break;
		}

	case M_Open:            // This demos vFileSelect dialog
		{
			vFileSelect fsel(this);     // an instance of vFileSelect

// Show the file select dialog
#ifdef VPATCH
			int ans = fsel.FileSelect("Open file",name,99,defaultSaveRecallFilter,fI,filedir);
#else
			int ans = fsel.FileSelect("Open file",name,99,defaultSaveRecallFilter,fI);
#endif

			if (!ans || !(*name))   // User did not pick a file name
			{
				return;
			}
			currentFileName = string(name);

// open the save/recall menuhandler
			delete menuHandler;
			menuHandler = new SaveRecallMenuHandler(this, -1);
// pass the save command to the menuhandler
			menuHandler->MenuCommand(FD_RECALL);

			break;
		}

	case M_Save:            // This would usually save a file
	case M_SaveAs:          // Save to a specified name
		{
//            note.Notice("Save");
// initialize the save/recall menu
// if there is not a current file name, do the file selection thingy - let the user select/enter a file
			if(currentFileName == string() || id == M_SaveAs)
			{
	
				vFileSelect fsel(this);     // an instance of vFileSelect

// Show the file select dialog
#ifdef VPATCH
				int ans = fsel.FileSelect("Open file",name,99,defaultSaveRecallFilter,fI,filedir);
#else
				int ans = fsel.FileSelect("Open file",name,99,defaultSaveRecallFilter,fI);
#endif
				if (!ans || !(*name))   // User did not pick a file name
				{
					return;
				}
// copy the name into the currentFileName string
				currentFileName = string(name);
			}

// open the save menuhandler
			delete menuHandler;
			menuHandler = new SaveRecallMenuHandler(this, -1);
// pass the save command to the menuhandler
			menuHandler->MenuCommand(FD_SAVE);
			break;
		}

#ifdef vDEBUG                   // Include debugging like this
        case M_SetDebug:
          {
            vDebugDialog debug(this);   // an instance of debug 
            debug.SetDebug();           // dialog - let user set
            break;
          }
#endif

        case M_Exit:            // Standard exit command
          {                     // Invoke the standard app Exit
            theApp->Exit();     // to close all windows
            break;              // will never get here
          }
	}
}

//============vdCmdWindow::AttributeMenuCommands=================================================


void vdCmdWindow::AttributeMenuCommand(ItemVal id, ItemVal val, CmdType cType)
{
		menuHandler->MenuCommand(id);
}
//==============vdCmdWindow::ViewMenuCommands=================================================



void vdCmdWindow::ViewMenuCommand(ItemVal id, ItemVal val, CmdType cType)
{
	switch(id)
	{
	case m_ViewReset:
		{
		vdglcanvas->ResetView();	
		break;
		}
	}
}


//================vdCmdWindow::ButtonBarCommands=========================================


void vdCmdWindow::ButtonBarCommand(ItemVal id, ItemVal val, CmdType cType)
{
	switch(id)
	{

// Operators
	case m_ClearMask:
		{	// set all the toggle buttons off
		typeMaskBehavior->Clear();
		break;
		}

	case m_Wildcard:	
		{	// set all the toggle buttons on
		typeMaskBehavior->All();
		break;
		}
        case m_Sum:		   
		{
		// toggle the sumMode;
		typeMaskBehavior->SetSumMode(GetValue(m_Sum));
		break;
		}
		
        case m_Point:		
	case m_Line:		
	case m_Circle:		
	case m_Segment:
	case m_Arc:
	case m_Ellipse:		
	case m_Curve:		
	case m_Group:		
		{	
		typeMaskBehavior->Selected(id);
		break;
		}

	case m_Pan:
		{
		functionMapBehavior->Selected(this,id);
		vdglcanvas->CancelAction();
		vdglcanvas->PickPan();
		break;
		}
	case m_CView:
		{
		functionMapBehavior->Selected(this,id);
		vdglcanvas->CancelAction();
		vdglcanvas->PickCenter();
		break;
		}
	case m_ZoomIn:
		{
		functionMapBehavior->Selected(this,id);
		vdglcanvas->CancelAction();
		vdglcanvas->ZoomIn();
		break;
		}
	case m_ZoomOut:
		{
		functionMapBehavior->Selected(this,id);
		vdglcanvas->CancelAction();
		vdglcanvas->ZoomOut();
		break;
		}
	case m_MaxZoom:
		{
		functionMapBehavior->Clear(this);
		vdglcanvas->CancelAction();
		break;
		}
	}
}

//====================vdCmdWindow::CanvasSelection=============================

void vdCmdWindow::CanvasSelection(const SelectStack& ss)
{
	menuHandler->DoSelection(ss);
}

//====================vdCmdWindow::CanvasPick=============================

void vdCmdWindow::CanvasPick(const SelectStack& ss)
{

//cerr << "-->CanvasPick()" << endl;

	Selection s = Selection(Handle(),ss.GetPoint(),ss.GetButton());

// filter the select stack according to the current button settings
	SelectionFilter sf = typeMaskBehavior->GetFilter();

	sf.SetCriteria(CLOSEST);

	SelectStack ssx  = ss.Filter(sf);

	try 
	{
		s = ssx.SelectTop(); 
	}
	catch (CoreException & ce)
	{
                //cerr << "CoreException raised in vdCmdWindow::CanvasPick()" << endl;
                //cerr << "       " << ce << endl;
        }

	menuHandler->DoPick(s);
}

