// vdcmdwin.h


// Copyright (C) 1997,1998  Cliff Johnson                                  //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

// Derive a window from the vCmdWindow class

#ifndef VDCMDWIN_H
#define VDCMDWIN_H

#include <v/vcmdwin.h>  	// So we can use vCmdWindow
#include <v/vmenu.h>    	// For the menu pane
#include <v/vcmdpane.h> 	// command pane
#include <v/vstatusp.h>
#include <v/vdialog.h>  	// dialogs

// vdapp support classes
#include <typemaskbehavior.h>		//HASA
#include <modifierbehavior.h>		//HASA
#include <functionmapbehavior.h>	//HASA
#include <inputstring.h>		//HASA

// data managment support classes
#include <entitybank.h>			//HASA

// debug support
#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include <vdglcanvas.h>			//HASA
#include <selection.h>
#include <vector>
#include <string>
#include <selectstack.h>

class MenuHandler;
class TableDrawables;

// 

class vdCmdWindow : public vCmdWindow
{

	// function flags
	enum {
		DEFAULT_SNAP_RESOLUTION = 2
	};

        friend int AppMain(int, char**);        // allow AppMain access

      public:           //---------------------------------------- public
        vdCmdWindow(char*, int, int);    // Constructor with size
        virtual ~vdCmdWindow();          // Destructor
        virtual void WindowCommand(ItemVal id,ItemVal val,CmdType cType);
        virtual void KeyIn(vKey keysym, unsigned int shift);

// process responses from vdglcanvas
	void CanvasPick(const SelectStack& ss);
	void CanvasSelection(const SelectStack& ss);

// command sub-handlers
	void FileMenuCommand(ItemVal id, ItemVal val, CmdType cType);
	void AttributeMenuCommand(ItemVal id, ItemVal val, CmdType cType);
	void ViewMenuCommand(ItemVal id, ItemVal val, CmdType cType);
	void ButtonBarCommand(ItemVal id, ItemVal val, CmdType cType);
//	void FunctionMenuCommand(ItemVal id, ItemVal val, CmdType cType);

	
      private:          //--------------------------------------- private

        vMenuPane* vdMainMenu;             // For the menu bar
	int runningFunction;
	int snapResolution; //  ATTENTION: resolution is actually 10 ^ snapResolution !!!!

// declare the canvas

	VDGLCanvas* vdglcanvas;		   // opengl canvas - 

        vCommandPane* typeMaskCmdPane;     // for the entity selection buttons

	vCommandPane* functionMenuCmdPane;      // for the functional menu 

	vStatusPane* inputStatusPane; 	        // reflection of text entry

// support class for keyboard entry
//	class InputString inputString;

// controller classes  for button behavior
	TypeMaskBehavior* typeMaskBehavior;
	ModifierBehavior* modifierBehavior;
	FunctionMapBehavior* functionMapBehavior;

// data manager class
	EntityBank* bank;

	CanvasRegister* drawregister;

// stack of selections and actions
	vector<Selection> cmdwinSelections;
	vector<int> cmdwinActions;
public:
// Entityetry creation functions
	void PointByPicking(const SelectStack& ss);

// menu manager class
	MenuHandler* menuHandler;
	friend class MenuHandler;

// manager interfaces
//	int LoadMenuLabel(int,const char*,int);
//	int LoadMenuButton(int,const char*,int);

private: // common data for the various menuHandlers to use
	int currentColor;
	unsigned short currentLineStyle;
	unsigned int currentThick;
	unsigned int currentPointSize;
	unsigned int currentLayer;
	
	string currentFileName;
	
	TableDrawables* tableDrawables;
};
#endif
