// vdglcanvas.h


// Copyright (C) 1997  Cliff Johnson                                       //
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public                    //
// License as published by the Free Software Foundation; either            //
// version 2 of the License, or (at your option) any later version.        //
//                                                                         //
// This software is distributed in the hope that it will be useful,        //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU General Public License       //
// along with this software (see COPYING); if not, write to the        //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //

#ifndef VDGLCANVAS_H
#define VDGLCANVAS_H

// this is the VD GL CANVAS CLASS (2D)
// initially, this class should provide these services:
// 
// registration and drawing of 2D points, lines, circles, coordinate systems, ellipses, and curves
// selection of registered graphic entities - returning registration handles, and relative
// entity picking and positional information.
// frame selection of registerd graphic entities.
// color, linestyle, and visibility control of registered entities
// zoom, pan, and  general 2d view control


// parent class
#include <v/vbglcnv.h>		//ISA

//support classes
#include <canvasglstate.h>	//HASA
#include <canvasregister.h>	//HASA
#include <pointstack.h>		//HASA

//#include <point.h>
//#include <line.h>

// forward declarations
class Handle;			//ITO
class Point;			//ITO
class Line;			//ITO
class Attributes;
class Visibility;

class VDGLCanvas : public vBaseGLCanvasPane
{

enum {
    NOMODE,
    PICKING,
    CENTERING,
    PANNING,
    ZOOMIN,
    ZOOMOUT,
    FRAMESELECT,
    BUFSIZE = 4096,
};

private:
	int initDone;

// Specializing classes
	CanvasGLState glState;
	CanvasRegister* canvasRegister;	   // load a register of which entities to draw

	PointStack pStack;	// for keeping track of picks...

//	vector <DrawableEntity> drawableRegister; // container for drawing methods for entities

// flags and other simple markers
	int pickSize;
	int interfaceMode;
	int pickCount;
	Attributes currentAttributes;

// grid plotting
	int gridStep;   // ATTENTION:  actual plotted step is 10 ^ gridstep units !!!! 
			// this is a power of 10 !!!! but of more than MAXGRIDLINES grid lines 
			// are calculated to be drawn, this is automaticall incremented by 1
	//bool drawGrid;  // if TRUE, grid is drawn during redraw.
		
public: // inhereted methods
	VDGLCanvas(CanvasRegister* cr = NULL, unsigned int glmode = vGL_Default);
	virtual ~VDGLCanvas();

	virtual void graphicsInit(void);

        virtual void MouseDown(int, int, int);
        virtual void MouseUp(int, int, int);
        virtual void MouseMove(int, int, int);

        virtual void Redraw(int, int, int, int);// Expose/redraw event
        virtual void Resize(int, int);          // Resize event

        virtual int GetWidth(); 		// Get width of canvas
        virtual int GetHeight();		// Get Height of canvas


// methods for vdCmdWindow to use...

// loading a canvas registery.    Loading a NULL gives a blank display.
	void LoadRegister(CanvasRegister* cr = NULL );

// add a new entity drawing method to the canvas
//	void LoadDrawableEntity(const DrawableEntity &);
									
// add an entity with the window - and with the current canvasRegister 
//	void Register(const Handle& h, const Attributes& a,const Visibility& v);

// set the current color and linestyle for external drawing.
	void SetAttributes(const Attributes& a);

// manipulate the current view
	void ModifyView(const vKey& );

// Primitive Drawing commands, probably not a very efficient way to do things...
//      void DrawPoint(const Point& p);
//      void DrawLine(const Line& l);
//      void DrawCircle(const Circle& c);
//      void DrawSegment(const Segment& s);
//      void DrawArc(const Arc& a);
//      void DrawEllipse(const Ellipse& e);
//      void DrawCurve(const Curve& c);

// view manipulation
	void SetScale(double s){ glState.SetScale(s); }
	void SetPPMM(double ppmm) { glState.SetPPMM(ppmm); }
	void SetCenter(const Point& p) { glState.SetCenter(p); }
	void SetOrtho2D() { glState.SetOrtho2D(GetWidth(), GetHeight()); }

	void CancelAction(); // turn off any pending mode/requests
	void PickPan();      // execute panning mode 
	void PickCenter();   // execute center picking mode
	void ZoomIn();
	void ZoomOut();
	void FrameSelect();
	void ResetView();
//	void PickEntityetry();

	Point PickedCoord(int x, int y) { return glState.GetCoord(x,y,GetWidth(),GetHeight()); }

	void DrawRegisteredEntities();
	void SelectRegisteredEntities(int x, int y, int w, int h, int button);
	void SendCmdWindowResponse(int x, int y, int button, GLint hits, GLuint *selectBuf);

	//void SetGridLines(bool status, int step = DEFAULTGRIDSTEP);
	//void DrawGridLines() ;
};

#endif
