/**
 **	Form.C - read stdin, parse cgi input
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>

#include "list.h"
#include "Form.h"

/*
typedef struct cgistruct
{
	struct cgistruct *next;
	char *name;
	char *value;
} CGI;

class Form
{
public:
	Form::Form(void);
	Form::~Form(void);


private:
	CGI *cgibase;
};
*/

Form::Form(void)
{
	CGI *cgi;
	char slask[500];
	char name[200];
	int i = 0;
	char c,chigh,clow;

	cgibase = NULL;
	current = NULL;

	*name = 0;

	fread(&c,1,1,stdin);
	while (!feof(stdin))
	{
		switch (c)
		{
			case '=': /* end of name */
				slask[i] = 0;
				i = 0;
				strcpy(name,slask);
				break;
			case '&': /* end of value */
				slask[i] = 0;
				i = 0;
				cgi = new CGI;
				cgi -> name = new char[strlen(name) + 1];
				strcpy(cgi -> name,name);
				cgi -> value = new char[strlen(slask) + 1];
				strcpy(cgi -> value,slask);
				addlistl(&cgibase, (LIST *)cgi);
				break;
			case '+': /* space */
				slask[i++] = ' ';
				break;
			case '%': /* hex value */
				fread(&chigh,1,1,stdin);
				chigh -= 48;
				if (chigh > 9)
					chigh -= 7;
				fread(&clow,1,1,stdin);
				clow -= 48;
				if (clow > 9)
					clow -= 7;
				slask[i++] = chigh * 16 + clow;
				break;
			default: /* just another char */
				slask[i++] = c;
				break;
		}
		fread(&c,1,1,stdin);
	}
	slask[i] = 0;
	i = 0;
	cgi = new CGI;
	cgi -> name = new char[strlen(name) + 1];
	strcpy(cgi -> name,name);
	cgi -> value = new char[strlen(slask) + 1];
	strcpy(cgi -> value,slask);
	addlistl(&cgibase, (LIST *)cgi);
}

Form::~Form(void)
{
	CGI *cgi,*tmp;

	for (cgi = cgibase; cgi; cgi = tmp)
	{
		delete cgi -> name;
		delete cgi -> value;
		tmp = cgi -> next;
		delete cgi;
	}
}

/* get names */

void Form::getfirst(char *n)
{
	current = cgibase;
	getnext(n);
}

void Form::getnext(char *n)
{
	if (current)
	{
		strcpy(n,current -> name);
		current = current -> next;
	} else
		*n = 0;
}

/* get value */
int Form::getvalue(char *n,char *v)
{
	CGI *cgi;
	int r = 0;

	for (cgi = cgibase; cgi; cgi = cgi -> next)
		if (!strcmp(cgi -> name,n))
			break;
	if (cgi)
	{
		strcpy(v,cgi -> value);
		r++;
	} else
		*v = 0;

	return r;
}

