/**
 **	Parse.C - parse a string
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Parse.h"

/* implementation of class Parse */

Parse::Parse()
{
	the_str = NULL;
	splits = NULL;
	*ord = 0;
	the_ptr = 0;
}

Parse::Parse(char *s)
{
	the_str = NULL;
	splits = NULL;
	*ord = 0;
	the_ptr = 0;
	the_str = new char[strlen(s) + 1];
	strcpy(the_str,s);
}

Parse::Parse(char *s,char *sp)
{
	the_str = NULL;
	splits = NULL;
	*ord = 0;
	the_ptr = 0;
	the_str = new char[strlen(s) + 1];
	strcpy(the_str,s);
	splits = new char[strlen(sp) + 1];
	strcpy(splits,sp);
}

#define FREE(x) if (x) delete x;

Parse::~Parse()
{
	FREE(the_str);
	FREE(splits);
}

#define C the_str[the_ptr]

short Parse::issplit(char c)
{
	short i;

	if (splits)
		for (i = 0; (size_t)i < strlen(splits); i++)
			if (splits[i] == c)
				return 1;
	return 0;
}

void Parse::getsplit(void)
{
	int x;

	if (C == '=')
	{
		x = the_ptr++;
	} else
	{
		while (C && (issplit(C)))
			the_ptr++;
		x = the_ptr;
		while (C && !issplit(C) && C != '=')
			the_ptr++;
	}
	if (x == the_ptr && C == '=')
		the_ptr++;
	strncpy(ord,the_str + x,the_ptr - x);
	ord[the_ptr - x] = 0;
}

void Parse::getword(void)
{
	int x;

	if (C == '=')
	{
		x = the_ptr++;
	} else
	{
		while (C && (C == ' ' || C == 9 || issplit(C)))
			the_ptr++;
		x = the_ptr;
		while (C && C != ' ' && C != 9 && !issplit(C) && C != '=')
			the_ptr++;
	}
	if (x == the_ptr && C == '=')
		the_ptr++;
	strncpy(ord,the_str + x,the_ptr - x);
	ord[the_ptr - x] = 0;
}

void Parse::getword(char *s)
{
	Parse::getword();
	strcpy(s,ord);
}

void Parse::getsplit(char *s)
{
	Parse::getsplit();
	strcpy(s,ord);
}

void Parse::getword(char *s,char *fill,int l)
{
	Parse::getword();
	*s = 0;
	while (strlen(s) + strlen(ord) < (size_t)l)
		strcat(s,fill);
	strcat(s,ord);
}

void Parse::getrest(char *s)
{
	while (C && (C == ' ' || C == 9 || issplit(C)))
		the_ptr++;
	strcpy(s,the_str + the_ptr);
}

long Parse::getvalue(void)
{
	Parse::getword();
	return atol(ord);
}


/* end of implementation of class Parse */
/***************************************************/
