/**
 **	list.C - linked list stuff
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include "list.h"
#include "smbconf.h"	/* blah SECTION, PARAM */

int listlen(void *_base)
{
	LIST *base = (LIST *)_base;
	LIST *q;
	int i = 0;

	for (q = base; q; q = q -> next)
		i++;
	return i;
}

void addlist(void *_base,LIST *item)
{
	LIST **base = (LIST **)_base;
	int qty = listlen(*base);

	item -> next = *base;
	*base = item;

	if (listlen(base) < qty)
	{
		printf("addlist() list error\n");
		exit(-1);
	}
}

void addlistl(void *_base,LIST *item)
{
	LIST **base = (LIST **)_base;
	LIST *q = *base;
	int qty = listlen(*base);

	item -> next = NULL;
	if (!q)
		*base = item;
	else
	{
		while (q -> next)
			q = q -> next;
		q -> next = item;
	}

	if (listlen(base) < qty)
	{
		printf("addlistl() list error\n");
		exit(-1);
	}
}

void removelist(void *_base,LIST *item)
{
	LIST **base = (LIST **)_base;
	LIST *q;
	int qty = listlen(*base);

	if (*base == item)
	{
		*base = item -> next;
	} else
	{
		q = *base;
		while (q)
			if (q -> next == item)
			{
				q -> next = item -> next;
			} else
			{
				q = q -> next;
			}
	}
	if (listlen(*base) != qty - 1)
	{
		printf("removelist() list error\n");
		exit(-1);
	}
}

void savelist(void *_base,int size,char *filename)
{
	LIST **base = (LIST **)_base;
	LIST *h;
	FILE *fil;
	int q = 0;
	long s = 0;

	if ((fil = fopen(filename,"wb")) != NULL)
	{
		for (h = *base; h; h = h -> next)
		{
			s += fwrite(h,1,size,fil);
			q++;
		}
		fclose(fil);
	}
}

void loadlist(void *_base,int size,char *filename)
{
	LIST *h;
	FILE *fil;

	if ((fil = fopen(filename,"rb")) != NULL)
	{
		while (!feof(fil))
		{
			h = new LIST;
			fread(h,1,size,fil);
			if (!feof(fil))
			{
				addlistl(_base,h);
			} else
				delete h;
		}
		fclose(fil);
	}
}

void addlistsort(void *_base,SLIST *item)
{
	SLIST **base = (SLIST **)_base;
	SLIST *q;

	item -> next = NULL;
	if ((q = *base) == NULL)
		*base = item;
	else
		if (strcmp(item -> s,q -> s) <= 0)
		{
			item -> next = *base;
			*base = item;
		} else
		{
			while (q -> next)
				if (strcmp(item -> s,q -> next -> s) <= 0)
				{
					item -> next = q -> next;
					q -> next = item;
					break;
				} else
					q = q -> next;
			q -> next = item;
		}
}

void addlistsection(void *_base,SECTION *item)
{
	SECTION **base = (SECTION **)_base;
	SECTION *q;

	item -> next = NULL;
	if ((q = *base) == NULL)
		*base = item;
	else
		if (strcmp(item -> section -> str1,q -> section -> str1) <= 0)
		{
			item -> next = *base;
			*base = item;
		} else
		{
			while (q -> next)
				if (strcmp(item -> section -> str1,q -> next -> section -> str1) <= 0)
				{
					item -> next = q -> next;
					q -> next = item;
					break;
				} else
					q = q -> next;
			q -> next = item;
		}
}

void addlistparam(void *_base,PARAM *item)
{
	PARAM **base = (PARAM **)_base;
	PARAM *q;

	item -> next = NULL;
	if ((q = *base) == NULL)
		*base = item;
	else
		if (strcmp(item -> param -> str1,q -> param -> str1) <= 0)
		{
			item -> next = *base;
			*base = item;
		} else
		{
			while (q -> next)
				if (strcmp(item -> param -> str1,q -> next -> param -> str1) <= 0)
				{
					item -> next = q -> next;
					q -> next = item;
					break;
				} else
					q = q -> next;
			q -> next = item;
		}
}

