/**
 **	options.C - smb.conf options stored here like
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>

#include "list.h"
#include "options.h"
#include "rwconf.h"
#include "Parse.h"
#include "utils.h"


	OPTION *optionbase = NULL;

	char *o_global[] = {
	 "add user script/string/()",
	 "announce as/NT/Win95/WfW/(NT)",
	 "announce version/string/(4.2)",
	 "auto services/string/()",
	 "bind interfaces only/boolean/(0)",
	 "browse list/boolean/(1)",
	 "change notify timeout/integer/(60)",
	 "character set/ISO8859-1/ISO8859-2/ISO8859-5/KOI8-R/(ISO8859-1)",
	 "client code page/437/737/850/852/861/866/932/936/949/950/(850)",
	 "coding system/string/()",
	 "codingsystem/-coding system",
	 "config file/string/()",
	 "deadtime/integer/(0)",
	 "debug timestamp/boolean/(1)",
	 "debug level/integer/(0)",
	 "debuglevel/-debug level",
	 "default/-default service",
	 "default service/service/()",
	 "delete user script/string/()",
	 "dfree command/string/()",
	 "dns proxy/boolean/(1)",
	 "domain admin group/string/()",
	 "domain admin users/string/()",
	 "domain controller/-",
	 "domain groups/string/()",
	 "domain guest group/string/()",
	 "domain guest users/string/()",
	 "domain logons/boolean/(0)",
	 "domain master/boolean/(0)",
	 "encrypt passwords/boolean/(0)",
	 "getwd cache/boolean/(0)",
	 "homedir map/string/(auto.home)",
	 "hosts equiv/string/()",
	 "interfaces/string/()",
	 "keepalive/integer/(0)",
	 "kernel oplocks/boolean/()",
	 "ldap filter/string/()",
	 "ldap port/integer/(389)",
	 "ldap root/string/()",
	 "ldap root passwd/string/()",
	 "ldap server/string/()",
	 "ldap suffix/string/()",
	 "lm announce/true/false/auto/(auto)",
	 "lm interval/integer/(60)",
	 "load printers/boolean/(1)",
	 "local master/boolean/(1)",
	 "lock dir/-lock directory",
	 "lock directory/string/(/tmp/samba)",
	 "log file/string/()",
	 "log level/-debug level",
	 "logfile/-log file",
	 "logon drive/string/()",
	 "logon home/string/()",
	 "logon path/string/(\\\\%N\\%U\\profile)",
	 "logon script/string/()",
	 "lpq cache time/integer/(10)",
	 "machine password timeout/integer/(604800)",
	 "mangled stack/integer/(50)",
	 "max disk size/integer/(0)",
	 "max log size/integer/(5000)",
	 "max mux/integer/(50)",
	 "max open files/integer/(10000)",
	 "max packet/-packetsize",
	 "max ttl/integer/(259200)",
	 "max wins ttl/integer/(518400)",
	 "max xmit/integer/(65535)",
	 "message command/string/()",
	 "min wins ttl/integer/(21600)",
	 "name resolve order/string/(lmhosts host wins bcast)",
	 "netbios aliases/string/()",
	 "netbios name/string/()",
	 "nis homedir/boolean/(0)",
	 "nt pipe support/boolean/(1)",
	 "nt smb support/boolean/(1)",
	 "null passwords/boolean/(0)",
	 "ole locking compatibility/boolean/(1)",
	 "os level/integer/(0)",
	 "packet size/-",
	 "panic action/string/()",
	 "passwd chat/string/()",
	 "passwd chat debug/boolean/(1)",
	 "passwd program/string/(/bin/passwd)",
	 "password level/integer/(0)",
	 "password server/string/()",
	 "prefered master/-preferred master",
	 "preferred master/boolean/(0)",
	 "preload/-auto services",
	 "printcap/-printcap name",
	 "printcap name/string/(/etc/printcap)",
	 "printer driver file/string/()",
	 "protocol/CORE/COREPLUS/LANMAN1/LANMAN2/NT1/(NT1)",
	 "read bmpx/boolean/(0)",
	 "read prediction/-",
	 "read raw/boolean/(1)",
	 "read size/integer/(2048)",
	 "remote announce/string/()",
	 "remote browse sync/string/()",
	 "root/-root directory",
	 "root dir/-root directory",
	 "root directory/string/(/)",
	 "security/user/share/server/domain/(user)",
	 "server string/string/(Samba %v)",
	 "shared mem size/integer/(1048576)",
	 "smb passwd file/string/()",
	 "smbrun/string/()",
	 "socket address/string/()",
	 "socket options/string/(TCP_NODELAY)",
	 "ssl/boolean/(0)",
	 "ssl CA certDir/string/()",
	 "ssl CA certFile/string/()",
	 "ssl ciphers/string/()",
	 "ssl client cert/string/()",
	 "ssl client key/string/()",
	 "ssl compatibility/boolean/(0)",
	 "ssl hosts/-ssl hosts resign",
	 "ssl hosts resign/string/()",
	 "ssl require clientcert/boolean/(0)",
	 "ssl require servercert/boolean/(0)",
	 "ssl server cert/string/()",
	 "ssl server key/string/()",
	 "ssl version/string/(ssl2or3)",
	 "stat cache/boolean/(1)",
	 "stat cache size/integer/(50)",
	 "strip dot/boolean/(0)",
	 "syslog/integer/(1)",
	 "syslog only/boolean/(0)",
	 "time offset/integer/(0)",
	 "time server/boolean/(0)",
	 "timestamp logs/boolean/(1)",
	 "unix password sync/boolean/(0)",
	 "unix realname/boolean/(0)",
	 "update encrypted/boolean/(0)",
	 "use rhosts/boolean/(0)",
	 "username level/integer/(0)",
	 "username map/string/()",
	 "valid chars/string/()",
	 "wins proxy/boolean/(0)",
	 "wins server/string/()",
	 "wins support/boolean/(0)",
	 "workgroup/string/(WORKGROUP)",
	 "write raw/boolean/(1)",
	 ""
	};

	char *o_section[] = {
	 "admin users/string/()",
	 "allow hosts/-hosts allow",
	 "alternate permissions/-",
	 "available/boolean/(1)",
	 "blocking locks/boolean/(1)",
	 "browsable/-browseable",
	 "browseable/boolean/(1)",
	 "case sensitive/boolean/(0)",
	 "casesignames/-case sensitive",
	 "comment/string/()",
	 "copy/service/()",
	 "create mask/string/(0744)",
	 "create mode/-create mask",
	 "default case/upper/lower/(lower)",
	 "delete readonly/boolean/(0)",
	 "delete veto files/boolean/(0)",
	 "deny hosts/-hosts deny",
	 "directory/-path",
	 "directory mask/string/(0755)",
	 "directory mode/-directory mask",
	 "dont descend/string/()",
	 "dos filetime resolution/boolean/(0)",
	 "dos filetimes/boolean/(0)",
	 "exec/-preexec",
	 "fake directory create times/boolean/(0)",
	 "fake oplocks/boolean/(0)",
	 "follow symlinks/boolean/(1)",
	 "force create mode/string/(000)",
	 "force directory mode/string/(000)",
	 "force group/string/()",
	 "force user/string/()",
	 "fstype/string/(NTFS)",
	 "group/-force group",
	 "guest account/string/()",
	 "guest ok/boolean/(0)",
	 "guest only/boolean/(0)",
	 "hide dot files/boolean/(1)",
	 "hide files/string/()",
	 "hosts allow/string/()",
	 "hosts deny/string/()",
	 "include/string/()",
	 "invalid users/string/()",
	 "locking/boolean/(1)",
	 "lppause command/string/()",
	 "lpq command/string/()",
	 "lpresume command/string/()",
	 "lprm command/string/()",
	 "magic output/string/()",
	 "magic script/string/()",
	 "mangle case/boolean/(0)",
	 "mangled map/string/()",
	 "mangled names/boolean/(1)",
	 "mangling char/string/(~)",
	 "map archive/boolean/(1)",
	 "map hidden/boolean/(0)",
	 "map system/boolean/(0)",
	 "map to guest/Never/Bad User/Bad Password/(Never)",
	 "max connections/integer/(0)",
	 "min print space/integer/(0)",
	 "only guest/-guest only",
	 "only user/boolean/(0)",
	 "oplocks/boolean/(1)",
	 "path/string/()",
	 "postexec/string/()",
	 "postscript/boolean/(0)",
	 "preexec/string/()",
	 "preserve case/boolean/(1)",
	 "print command/string/()",
	 "print ok/-printable",
	 "printable/boolean/(0)",
	 "printer/string/()",
	 "printer driver/string/()",
	 "printer driver location/string/()",
	 "printer name/-printer",
	 "printing/BSD/AIX/LPRNG/PLP/SYSV/HPUX/QNX/SOFTQ",
	 "public/-guest ok",
	 "queuepause command/string/()",
	 "queueresume command/string/()",
	 "read list/string/()",
	 "read only/boolean",
	 "readonly/-read only",
	 "revalidate/boolean/(0)",
	 "root postexec/string/()",
	 "root preexec/string/()",
	 "set directory/boolean/(0)",
	 "share modes/boolean/(1)",
	 "short preserve case/boolean/(1)",
	 "status/boolean/(1)",
	 "strict locking/boolean/(0)",
	 "strict sync/boolean/(0)",
	 "sync always/boolean/(0)",
	 "user/-username",
	 "username/string/()",
	 "users/-username",
	 "valid users/string/()",
	 "veto files/string/()",
	 "veto oplock files/string/()",
	 "volume/string/()",
	 "wide links/boolean/(1)",
	 "writable/-writeable",
	 "write list/string/()",
	 "write ok/-writeable",
	 "writeable/boolean",
	 ""
	};

OPTION *name2option(char *s)
{
	OPTION *o;

	for (o = optionbase; o; o = o -> next)
		if (!strcmp(o -> option,s))
			break;
	return o;
}

void add_option(char *s,int sectiontype)
{
	OP *op = get_option_info(s);
	OPTION *o = name2option(op -> realname);

	if (!o && *op -> realname)
	{
		o = new OPTION;
		strcpy(o -> option,op -> realname);
		o -> usedby = 0;
		o -> inplace = 0;
		addlistsort(&optionbase, (SLIST *)o);
	}
	o -> usedby |= hex[sectiontype];
}

	short option_global;

char *find_option(char *option)
{
	short i;
	short l = strlen(option);

	i = 0;
	while (*o_global[i])
		if (!strncmp(o_global[i],option,strlen(option)) &&
		     strlen(o_global[i]) >= (size_t)l &&
		    (o_global[i][l] == '/' || o_global[i][l] == 0))
		{
			option_global = 1;
			return o_global[i];
		} else
			i++;

	i = 0;
	while (*o_section[i])
		if (!strncmp(o_section[i],option,strlen(option)) && 
		     strlen(o_section[i]) >= (size_t)l && 
		    (o_section[i][l] == '/' || o_section[i][l] == 0))
		{
			option_global = 0;
			return o_section[i];
		} else
			i++;

	return NULL;
}

void show_option(char *option,char *value,short line)
{
	SECTION *se;
	OP *op;
	Parse *pa;
	char *s;
	char test[100];
	int checked;

	op = get_option_info(option);
	s = find_option(option);

	if (s) /* found */
	{
		pa = new Parse(s,"/");
		pa -> getsplit(); /* option */
		pa -> getsplit(test);
		if (*test == '-')
		{
			if (test[1])
				show_option(test + 1,value,line);
			else
			{
				printf("<tr>\n");
				printf("<td colspan=2 align=middle bgcolor=#ff4040>Defunct option '%s' value'%s'</td>\n",
				 option,value);
				printf("</tr>\n");
			}
		} else
		{
			printf("<td align=right> <b>%s (%s) =</b> </td>\n",option,op -> global ? "G" : "S");
			printf("<td>\n");
			if (!strcmp(test,"service")) /* other service */
			{
				printf("<select name=line%d>\n",line);
				printf("<option>%s\n",value);
				for (se = sectionbase; se; se = se -> next)
				{
					strip(se -> section -> str1,test);
					if (strcasecmp(value,test))
						printf("<option>%s\n",test);
				}
				printf("</select>\n");
			} else
			if (!strcmp(test,"boolean")) /* Yes / No */
			{
				if (*value == '1' ||
				    *value == 'y' || *value == 'Y' ||
				    *value == 't' || *value == 'T')
					checked = 1;
				else
					checked = 0;
				printf("<input type=radio name=line%d value=yes%s>Yes\n",line,checked ? " CHECKED" : "");
				printf("<input type=radio name=line%d value=no%s>No\n",line,checked ? "" : " CHECKED");
			} else
			if (!strcmp(test,"string"))
			{
				printf("<input type=text name=line%d size=%d value=\"%s\">\n",
				 line,min(80,(strlen(value) / 10 + 1) * 10),value);
			} else
			if (!strcmp(test,"integer"))
			{
				printf("<input type=text name=line%d size=10 value=%s>\n",line,value);
			} else /* select list */
			{
				printf("<select name=line%d>\n",line);
				printf("<option>%s\n",value);
				while (*test)
				{
					if (strcasecmp(value,test) && *test != '(')
						printf("<option>%s\n",test);
					pa -> getsplit(test);
				}
				printf("</select>\n");
			}
			printf("</td>\n");
		}
		delete pa;
	} else
	{
		printf("<tr>\n");
		printf("<td colspan=2 align=middle bgcolor=#ff4040>Option not found '%s' value '%s'</td>\n",
		 option,value);
		printf("</tr>\n");
	}
}


/*
 * Get option info
 */

OP *get_option_info(char *option)
{
static	OP op;
	Parse *pa;
	char *s = find_option(option);
	char test[100];

	*op.realname = 0;
	*op.def = 0;
	op.global = option_global;
	if (!s)
	{
		op.type = OPTYPE_NOTFOUND;
		return &op;
	}
	pa = new Parse(s,"/");
	pa -> getsplit(op.realname);
	pa -> getsplit(test);
	if (!strcmp(test,"boolean"))
	{
		op.type = OPTYPE_BOOLEAN;
		pa -> getsplit(test);
		strip(test,op.def);
	} else
	if (!strcmp(test,"integer"))
	{
		op.type = OPTYPE_INTEGER;
		pa -> getsplit(test);
		strip(test,op.def);
	} else
	if (!strcmp(test,"string"))
	{
		op.type = OPTYPE_STRING;
		pa -> getsplit(test);
		strip(test,op.def);
	} else
	if (!strcmp(test,"service"))
	{
		op.type = OPTYPE_SERVICE;
		pa -> getsplit(test);
		strip(test,op.def);
	} else
	if (*test == '-')
	{
		if (test[1])
		{
			get_option_info(test + 1);
		} else
			op.type = OPTYPE_NOTUSED;
	} else /* select */
	{
		op.type = OPTYPE_SELECT;
		while (*test)
		{
			if (*test == '(')
			{
				strip(test,op.def);
			}
			pa -> getsplit(test);
		}
	}
	delete pa;

	return &op;
}

