/**
 **	rwconf.C - read 'shares.txt'
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>

#include "list.h"
#include "rwconf.h"

	SHARES *sharesbase;
	FORM *formbase;
	int hex[] = { 1,2,4,8,16,32,64,128,256,512,1024,2048,4096 };


void fget(char *s,int l,FILE *f)
{
	fgets(s,l,f);
	s[strlen(s) - 1] = 0;
}

void readshares(void)
{
	FILE *fil;
	SHARES *sh;
	char slask[200];

	sharesbase = NULL;

	if ((fil = fopen(SHARESFILE,"rt")) != NULL)
	{
		fget(slask,200,fil);
		while (*slask == '#' && !feof(fil))
			fget(slask,200,fil);
		while (!feof(fil))
		{
			sh = new SHARES;
			sh -> one = new char[strlen(slask) + 1];
			strcpy(sh -> one,slask);
			fget(slask,200,fil);
			while (*slask == '#' && !feof(fil))
				fget(slask,200,fil);
			if (!feof(fil))
			{
				sh -> many = new char[strlen(slask) + 1];
				strcpy(sh -> many,slask);
				addlistl(&sharesbase, (LIST *)sh);
				fget(slask,200,fil);
				while (*slask == '#' && !feof(fil))
					fget(slask,200,fil);
			}
		}
		fclose(fil);
	}
}

void readforms(void)
{
	FILE *fil;
	FORM *f;
	char slask[200];
	char descr[200];

	formbase = NULL;
	*descr = 0;
	if ((fil = fopen(FORMSFILE,"rt")) != NULL)
	{
		fget(slask,200,fil);
		while (!feof(fil))
		{
			if (*slask && *slask != ';' && *slask != '#')
			{
				if (!*descr)
					strcpy(descr,slask);
				else
				{
					f = new FORM;
					strcpy(f -> descr,descr);
					strcpy(f -> formfile,slask);
					addlistl(&formbase, (LIST *)f);
					*descr = 0;
				}
			}
			fget(slask,200,fil);
		}
		fclose(fil);
	}
}
