/**
 **	smb2html.C - generate HTML document
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "smbconf.h"
#include "rwconf.h"
#include "Form.h"
#include "options.h"
#include "utils.h"
#include "smbread.h"
#include "list.h"


/*
 * Generate HTML form(s)
 */

void theader(char *s,char *title)
{
	printf("<td %s bgcolor=#a0a0a0> %s </td>\n",s,title);
}

void theader2(char *s)
{
	printf("<td align=right bgcolor=#80ff80> %s </td>\n",s);
}

void end_section(SMBCONF *section)
{
	OPTION *o;
	SECTION *se;
	PARAM *p;
	OP *op;

	for (se = sectionbase; se; se = se -> next)
		if (se -> section == section)
			break;

	printf("<tr>\n");
	printf("<td colspan=2 align=middle>\n");
	printf("<input type=submit name=submit value=\" Change \">\n");
	printf("</td>\n");
	printf("</tr>\n");

	printf("<tr><td colspan=2><br></td></tr>\n");

	printf("<tr>\n");
	theader2("Add option");
	printf("<td><select name=option>\n");
	printf("<option>\n");
	for (o = optionbase; o; o = o -> next)
		if ((o -> usedby & hex[section -> sectiontype]) != 0)
			printf("<option>%s\n",o -> option);
	printf("</select>\n");
	printf(" / ");
	printf("<input type=text name=option2 size=20>\n");
	printf("<input type=submit name=add value=\" Add option \">\n");
	printf("</td>\n");
	printf("</tr>\n");

	printf("<tr>\n");
	theader2("Delete option");
	printf("<td><select name=deleteoption>\n");
	printf("<option>\n");
	for (p = se ? se -> parambase : NULL; p; p = p -> next)
	{
		op = get_option_info(p -> param -> str1);
		if (*op -> realname)
			printf("<option>%s\n",op -> realname);
	}
	printf("</select>\n");
	printf("<input type=submit name=delopt value=\" Delete option \">\n");
	printf("</td>\n");
	printf("</tr>\n");

	printf("</table>\n");
	printf("</form>\n");
	printf("<br>\n");
}

int numsections(int type)
{
	SMBCONF *smb;
	int r = 0;

	for (smb = smbconfbase; smb; smb = smb -> next)
		if (smb -> type == SMB_SECTION && smb -> sectiontype == type)
			r++;

	return r;
}

void show_shares(char *fn,int show)
{
	SMBCONF *smb,*section = NULL,*smb2;
	SHARES *sh;
	SECTION *se;
	OP *op;
	char slask[200];
	short h;
	short i;
	short visa;
	short global;


/*
 * Show sections
 */

	printf("<form action=options.sh method=post>\n");
	printf("<input type=hidden name=smbconf value=\"%s\">\n",fn);
	printf("<input type=hidden name=show value=%d>\n",show);
	printf("<table>\n");
	printf("<tr>\n");
	theader("align=middle","Share type");
	theader("align=middle","Show");
	theader("align=middle colspan=2","Shares");
	printf("</tr>\n");
	i = 0;
	for (sh = sharesbase; sh; sh = sh -> next)
	{
		if (numsections(i))
		{
			printf("<tr><td valign=top align=right>%s\n",sh -> many);
			printf("</td>\n");
			printf("<td valign=top align=middle><input type=checkbox name=show%d value=%d%s>\n",
			 i,hex[i],((show & hex[i]) != 0) ? " CHECKED" : "");
			printf("</td>\n");
			printf("<td valign=top align=left colspan=2>\n");
			for (smb = smbconfbase; smb; smb = smb -> next)
			{
				if (smb -> type == SMB_SECTION && smb -> sectiontype == i)
				{
					strip(smb -> str1,slask);
					if (!strcmp(smb -> filename,"smb.conf"))
						printf("[<a href=#%d>%s</a>]\n",smb -> section_num,slask);
					else
						printf("[%s::<a href=#%d>%s</a>]\n",smb -> filename,smb -> section_num,slask);
				}
			}
			printf("</td></tr>\n");
		}
		i++;
	}

	printf("<tr><td colspan=2 align=middle>\n");
	printf("<input type=submit value=\" Change options \">\n");
	printf("</td>\n");

	printf("<td colspan=1 align=middle>\n");
	printf("<select name=copyshare>\n");
	printf("<option>\n");
	for (se = sectionbase; se; se = se -> next)
		if (se -> section -> sectiontype > 2)
			printf("<option>%s\n",se -> section -> str1);
	printf("</select>\n");
	printf("<input type=submit name=copy value=\" Copy share \">\n");
	printf("</td>\n");

	printf("<td colspan=1 align=middle>\n");
	printf("<select name=deleteshare>\n");
	printf("<option>\n");
	for (se = sectionbase; se; se = se -> next)
		if (se -> section -> sectiontype > 2)
			printf("<option>%s\n",se -> section -> str1);
	printf("</select>\n");
	printf("<input type=submit name=delete value=\" Delete share \">\n");
	printf("</td>\n");
	printf("</tr>\n");

	printf("</table>\n");
	printf("</form>\n");

	printf("<hr>\n");


/*
 * Show sections in detail
 */

	h = 0;
	for (smb2 = smbconfbase; smb2; smb2 = smb2 -> next)	/* scan for sections */
	 if (smb2 -> type == SMB_SECTION)
	  for (global = 1; global >= 0; global--)		/* show global params first, then share params */
	  for (smb = smb2; smb; smb = smb -> next)		/* scan for params until eof */
	   if (smb -> section_num == smb2 -> section_num)
	   {
		switch (smb -> type)
		{
			case SMB_EMPTYLINE:
			case SMB_COMMENT:
				break;
			case SMB_SECTION:
				if (global)
				{
					if (h)
					{
						end_section(section);
						h = 0;
					}
					/*
					 * Section start
					 */
					visa = show & hex[smb -> sectiontype];
					if (visa)
					{
						if (smb -> str2) /* section renamed */
							strip(smb -> str2,slask);
						else
							strip(smb -> str1,slask);
						printf("<a name=%d></a>\n",smb -> section_num);
						printf("<h2>%s::%s</h2>\n",smb -> filename,smb -> str1);
						strip(smb -> str1,slask); /* always use current name */
						printf("<form action=conf.sh#%d method=post>\n",smb -> section_num);
						printf("<input type=hidden name=smbconf value=\"%s\">\n",fn);
						printf("<input type=hidden name=show value=%d>\n",show);
						printf("<input type=hidden name=section value=\"%s\">\n",smb -> str1);
						printf("<input type=hidden name=sectionnum value=%d>\n",smb -> section_num);
						printf("<table border=1 width=100%%>\n");
						if (smb -> sectiontype > 2) /* not global, homes, printers */
						{
							printf("<tr>\n");
							theader2("Share type");
							printf("<td>\n");
							i = 0;
							for (sh = sharesbase; sh; sh = sh -> next)
							{
								if (i > 2)
									printf("<input type=radio name=sectiontype value=%d%s>%s\n",
									 i,smb -> sectiontype == i ? " CHECKED" : "",sh -> one);
								i++;
							}
							printf("</td>\n");
							printf("</tr>\n");

							printf("<tr>\n");
							theader2("Share name");
							printf("<td>\n");
							printf("<input type=text name=sharename size=20 value=\"%s\">\n",
							 smb -> str1);
							printf("</td>\n");
							printf("</tr>\n");
						}
						h++;
					}
					section = smb;
				} /* global */
				break;
			case SMB_PARAMVALUE:
				op = get_option_info(smb -> str1);
				if (op -> global == global && visa)
				{
					printf("<tr>\n");
					show_option(smb -> str1,smb -> str2,smb -> linenum);
					printf("</tr>\n");
				}
				break;
			case SMB_INCLUDE:
				strcpy(slask,"include");
				op = get_option_info(slask);
				if (op -> global == global && visa)
				{
					printf("<tr>\n");
					printf("<td align=right><b>include =</b></td>\n");
					printf("<td bgcolor=%s>\n",!strcmp(smb -> str2,"OK") ? "#40ff40" : "#ff4040");
					printf("<input type=text name=line%d size=%d value=\"%s\">\n",
					 smb -> linenum,min(80,(strlen(smb -> str1) / 10 + 1) * 10),smb -> str1);
					printf("File open status: %s\n",smb -> str2);
					printf("</td>\n");
					printf("</tr>\n");
				}
				break;
		} /* switch */
	   }
	if (h)
		end_section(section);

}

int options_equal(char *option1,char *option2)
{
	OP *op;
	char realname[100];

	op = get_option_info(option1);
	strcpy(realname,op -> realname);
	op = get_option_info(option2);
	return !strcmp(realname,op -> realname);
}

void show_form(char *conffile,char *formfile,int show,int formnum)
{
	FILE *fil;
	SECTION *se = NULL;
	PARAM *p;
	char slask[200];

	printf("<form action=postform.sh method=post>\n");
	printf("<input type=hidden name=smbconf value=\"%s\">\n",conffile);
	printf("<input type=hidden name=show value=%d>\n",show);
	printf("<input type=hidden name=formnum value=%d>\n",formnum);
	printf("<table>\n");
	if ((fil = fopen(formfile,"rt")) != NULL)
	{
		fget(slask,200,fil);
		while (!feof(fil))
		{
			if (*slask == 0 || *slask == '#') /* empty line, comment */
			{
			} else
			if (*slask == '[') /* share to edit */
			{
				printf("<input type=hidden name=section value=\"%s\">\n",slask);
				for (se = sectionbase; se; se = se -> next)
				{
					if (!strcasecmp(se -> section -> str1,slask) &&
					    !strcasecmp(se -> section -> filename,"smb.conf"))
						break;
				}
				if (se)
					printf("<input type=hidden name=sectionnum value=%d>\n",se -> section -> section_num);
			} else
			if (se)
			{
				if (*slask == ';') /* some descriptive header text */
				{
					printf("<tr><td colspan=2 bgcolor=#c0ffc0><font size=+1> %s </font></td></tr>\n",slask + 1);
				} else /* it is an option to edit */
				{
					for (p = se -> parambase; p; p = p -> next)
						if (options_equal(p -> param -> str1,slask))
							break;

					printf("<tr>\n");
					if (p)
						show_option(p -> param -> str1,p -> param -> str2,p -> param -> linenum);
					else
					{
						printf("<td align=right><b> %s = </b></td>\n",slask);
						printf("<td></td>\n");
					}
					printf("</tr>\n");
				}
			} /* if (se) */
			fget(slask,200,fil);
		}
		fclose(fil);
	}

	if (se)
	{
		printf("<tr>\n");
		printf("<td colspan=2 align=middle>\n");
		printf("<input type=submit name=submit value=\" Change \">\n");
		printf("</td>\n");
		printf("</tr>\n");

		printf("<tr><td colspan=2><br></td></tr>\n");

		printf("<tr>\n");
		theader2("Add option");
		printf("<td><select name=option>\n");
		printf("<option>\n");
		if ((fil = fopen(formfile,"rt")) != NULL)
		{
			fget(slask,200,fil);
			while (!feof(fil))
			{
				if (*slask && *slask != '[' && *slask != ';' && *slask != '#')
				{
					for (p = se -> parambase; p; p = p -> next)
						if (options_equal(p -> param -> str1,slask))
							break;
					if (!p)
						printf("<option>%s\n",slask);
				}
				fget(slask,200,fil);
			}
			fclose(fil);
		}
		printf("</select>\n");
		printf("<input type=submit name=add value=\" Add option \">\n");
		printf("</td>\n");
		printf("</tr>\n");

		printf("<tr>\n");
		theader2("Delete option");
		printf("<td><select name=deleteoption>\n");
		printf("<option>\n");
		if ((fil = fopen(formfile,"rt")) != NULL)
		{
			fget(slask,200,fil);
			while (!feof(fil))
			{
				if (*slask && *slask != '[' && *slask != ';' && *slask != '#')
				{
					for (p = se -> parambase; p; p = p -> next)
						if (options_equal(p -> param -> str1,slask))
							break;
					if (p)
						printf("<option>%s\n",slask);
				}
				fget(slask,200,fil);
			}
			fclose(fil);
		}
		printf("</select>\n");
		printf("<input type=submit name=delopt value=\" Delete option \">\n");
		printf("</td>\n");
		printf("</tr>\n");
	} /* if (se) */

	printf("</table>\n");
	printf("</form>\n");
}

void smb2html(int num,char *fn,int show)
{
	FORM *f;
	int i;

/* header */
	printf("<html><head><title>Samba configuration</title></head>\n");
	printf("<body bgcolor=#c0c0c0>\n");

	printf("<h2>Samba configuration</h2>\n");

	printf("<form action=menu.sh method=post>\n");
	printf("<input type=hidden name=smbconf value=\"%s\">\n",fn);
	printf("<input type=hidden name=show value=%d>\n",show);
	printf("<input type=submit name=submit value=\"Edit shares\">\n");
	for (f = formbase; f; f = f -> next)
		printf("<input type=submit name=submit value=\"%s\">\n",f -> descr);
	printf("</form>\n");

	printf("<hr>\n");

	if (!num)
		show_shares(fn,show);
	else
	{
		i = num - 1;
		f = formbase;
		while (i-- && f)
			f = f -> next;
		if (f)
			show_form(fn,f -> formfile,show,num);
	}

/* footer */
	printf("<br>\n");
	printf("<hr>\n");

	printf("</body>\n");
	printf("</html>\n");
}


/*
 * main()
 */

int main(int argc,char *argv[])
{
	SHARES *sh;
	OPTION *o;
	FORM *f;
	Form *form = new Form();	/* read cgi input */
	char slask[200];
	char conffile[200];
	int show;
	int i;
	int formnum;

	if (argc >= 2)
	{
		readshares();
		readforms();

		formnum = 0;		/* edit shares */

		switch (atoi(argv[1]))
		{
			case 0: /* init.sh */
				smbreadfile(argv[2],NULL,ACTION_NONE,"");
				strcpy(conffile,argv[2]);
				show = 0x7fff;
				break;
			case 1: /* conf.sh */
				form -> getvalue("smbconf",conffile);
				form -> getvalue("show",slask);
				show = atoi(slask);
				form -> getvalue("add",slask);	/* check if 'Add' is pressed */
				if (*slask)
				{
				/* 'Add' pressed */
					form -> getvalue("option",slask);
					if (!*slask)
					{
						form -> getvalue("option2",slask);
						if (*slask)
						{
							o = name2option(slask);
							if (!o)
							{
								o = new OPTION;
								strcpy(o -> option,slask);
								o -> usedby = 0;
								o -> inplace = 0;
								addlistsort(&optionbase, (SLIST *)o);
							}
						}
					}
					smbreadfile(conffile,form,ACTION_ADDOPT,slask);
					break;
				}
				form -> getvalue("delopt",slask);	/* check if 'Delete option' is pressed */
				if (*slask)
				{
				/* 'Delete option' pressed */
					form -> getvalue("deleteoption",slask);
					smbreadfile(conffile,form,ACTION_DELOPT,slask);
				} else
				{
				/* 'Change' pressed */
					smbreadfile(conffile,form,ACTION_MODIFY,"");
				}
				break;
			case 2: /* options.sh */
				form -> getvalue("smbconf",conffile);
				form -> getvalue("show",slask);
				show = atoi(slask);

				form -> getvalue("copy",slask);	/* check if 'Copy' is pressed */
				if (*slask)
				{
				/* 'Copy' pressed */
					form -> getvalue("copyshare",slask);
					smbreadfile(conffile,form,ACTION_COPYSHARE,slask);
					break;
				}
				form -> getvalue("delete",slask);	/* check if 'Delete' is pressed */
				if (*slask)
				{
				/* 'Delete' pressed */
					form -> getvalue("deleteshare",slask);
					smbreadfile(conffile,form,ACTION_DELSHARE,slask);
					break;
				} else
				{
					show = 0;
					i = 0;
					for (sh = sharesbase; sh; sh = sh -> next)
					{
						sprintf(slask,"show%d",i);
						form -> getvalue(slask,slask);
						show |= atoi(slask);
						i++;
					}
					smbreadfile(conffile,NULL,ACTION_NONE,"");
				}
				break;
			case 3: /* menu.sh */
				form -> getvalue("smbconf",conffile);
				form -> getvalue("show",slask);
				show = atoi(slask);
				form -> getvalue("submit",slask);
				if (!strcasecmp(slask,"edit shares"))
				{
					smbreadfile(conffile,NULL,ACTION_NONE,"");
					formnum = 0;
				} else
				{
					formnum = 1;
					for (f = formbase; f; f = f -> next)
						if (!strcasecmp(f -> descr,slask))
							break;
						else
							formnum++;
					if (f)
					{
						smbreadfile(conffile,NULL,ACTION_NONE,"");
					} else
						formnum = 0;
				}
				break;
			case 4: /* postform.sh */
				form -> getvalue("smbconf",conffile);
				form -> getvalue("show",slask);
				show = atoi(slask);
				form -> getvalue("formnum",slask);
				formnum = atoi(slask);
				form -> getvalue("add",slask);	/* check if 'Add' is pressed */
				if (*slask)
				{
				/* 'Add' pressed */
					form -> getvalue("option",slask);
					if (*slask)
					{
						o = name2option(slask);
						if (!o)
						{
							o = new OPTION;
							strcpy(o -> option,slask);
							o -> usedby = 0;
							o -> inplace = 0;
							addlistsort(&optionbase, (SLIST *)o);
						}
					}
					smbreadfile(conffile,form,ACTION_ADDOPT,slask);
					break;
				}
				form -> getvalue("delopt",slask);	/* check if 'Delete option' is pressed */
				if (*slask)
				{
				/* 'Delete option' pressed */
					form -> getvalue("deleteoption",slask);
					smbreadfile(conffile,form,ACTION_DELOPT,slask);
				} else
				{
				/* 'Change' pressed */
					smbreadfile(conffile,form,ACTION_MODIFY,"");
				}
				break;
		} /* switch */

		/*
		 * smb2html() :: Generate html document
		 *
		 * pass some info to generated form, so we don't forget it:
		 *  formnum - form to generate (0-share view)
		 *  conffile - smb.conf full pathname
		 *  show - which share types to show on formnum#0
		 *
		 */

		smb2html(formnum,conffile,show);

	}
	delete form;
}
