/**
 **	smbconf.h - Samba config
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef SMBCONF_H
#define SMBCONF_H

/*
#define UCASEPARAM
*/

#define SMB_EMPTYLINE 0
#define SMB_COMMENT 1
#define SMB_PARAMVALUE 2
#define SMB_SECTION 3
#define SMB_INCLUDE 4


typedef struct smbconfstruct
{
	struct smbconfstruct *next;
	short level;		/* 0 - base smb.conf file, 1..x include files */
	short linenum;
	short type;
	char *str1;
	char *str2;
	short sectiontype;
	short section_num;	/* 0 = first section, -1 = copied section, >0 more sections */
	char *filename;		/* original conf file name */
} SMBCONF;

typedef struct paramstruct
{
	struct paramstruct *next;
	SMBCONF *param;
} PARAM;

typedef struct sectionstruct
{
	struct sectionstruct *next;
	SMBCONF *section;
	PARAM *parambase;
} SECTION;

extern	SMBCONF *smbconfbase;
extern	SECTION *sectionbase;

#endif
