/**
 **	smbread.C - Samba config
 **
 **	Written: 1999-Feb-10 ah@instrumentpolen.se
 **/

/*
Copyright (C) 1999  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "smbconf.h"
#include "Parse.h"
#include "list.h"
#include "Form.h"
#include "smb2html.h"
#include "rwconf.h"
#include "options.h"
#include "smbread.h"

	SMBCONF *smbconfbase = NULL;
	SECTION *sectionbase = NULL;
	short linecount = 0;
	short current_sectiontype;
	short section_num = 0;


SMBCONF *add_emptyline(int level,FILE *fil2,int num)
{
	SMBCONF *smb;

	smb = new SMBCONF;
	smb -> level = level;
	smb -> linenum = linecount++;
	smb -> type = SMB_EMPTYLINE;
	smb -> str1 = new char[2];
	strcpy(smb -> str1,";");
	smb -> str2 = NULL;
	smb -> sectiontype = 0;
	smb -> section_num = num;
	smb -> filename = NULL;
	addlistl(&smbconfbase, (LIST *)smb);

	if (fil2)
		fprintf(fil2,"\n");

	return smb;
}

void add_comment(int level,char *s,FILE *fil2,int num)
{
	SMBCONF *smb;

	smb = new SMBCONF;
	smb -> level = level;
	smb -> linenum = linecount++;
	smb -> type = SMB_COMMENT;
	smb -> str1 = new char[strlen(s) + 1];
	strcpy(smb -> str1,s);
	smb -> str2 = NULL;
	smb -> sectiontype = 0;
	smb -> section_num = num;
	smb -> filename = NULL;
	addlistl(&smbconfbase, (LIST *)smb);

	if (fil2)
		fprintf(fil2,"%s\n",s);
}

SMBCONF *add_paramvalue(int level,char *p,char *v,FILE *fil2,int num)
{
	SMBCONF *smb;

	smb = new SMBCONF;
	smb -> level = level;
	smb -> linenum = linecount++;
	smb -> type = SMB_PARAMVALUE;
	smb -> str1 = new char[strlen(p) + 1];
	strcpy(smb -> str1,p);
	smb -> str2 = new char[strlen(v) + 1];
	strcpy(smb -> str2,v);
	smb -> sectiontype = 0;
	smb -> section_num = num;
	smb -> filename = NULL;
	addlistl(&smbconfbase, (LIST *)smb);

	add_option(p,current_sectiontype);

	if (fil2)
		fprintf(fil2,"%c%s = %s\n",9,p,v);

	return smb;
}

SMBCONF *add_section(int level,char *s,FILE *fil2,int sectiontype,int num,char *fn)
{
	SMBCONF *smb;

	if (!strcasecmp(s,"[global]"))
		sectiontype = 0;
	else
	if (!strcasecmp(s,"[homes]"))
		sectiontype = 1;
	else
	if (!strcasecmp(s,"[printers]"))
		sectiontype = 2;
	else
		if (sectiontype < 3)
			sectiontype = 4; /* other share */

	smb = new SMBCONF;
	smb -> level = level;
	smb -> linenum = linecount++;
	smb -> type = SMB_SECTION;
	smb -> str1 = new char[strlen(s) + 1];
	strcpy(smb -> str1,s);
	smb -> str2 = NULL;
	smb -> sectiontype = sectiontype;
	smb -> section_num = num;
	smb -> filename = new char[strlen(fn) + 1];
	strcpy(smb -> filename,fn);
	addlistl(&smbconfbase, (LIST *)smb);

	if (fil2)
	{
		fprintf(fil2,"### sectiontype %d\n",sectiontype);
		fprintf(fil2,"%s\n",s);
	}
	current_sectiontype = sectiontype;

	return smb;
}

SMBCONF *add_include(int level,char *fn,char *stat,FILE *fil2,int num)
{
	SMBCONF *smb;

	smb = new SMBCONF;
	smb -> level = level;
	smb -> linenum = linecount++;
	smb -> type = SMB_INCLUDE;
	smb -> str1 = new char[strlen(fn) + 1];
	strcpy(smb -> str1,fn);
	smb -> str2 = new char[strlen(stat) + 1];
	strcpy(smb -> str2,stat);
	smb -> sectiontype = 0;
	smb -> section_num = num;
	smb -> filename = NULL;
	addlistl(&smbconfbase, (LIST *)smb);

	add_option("include",current_sectiontype);

	if (fil2)
		fprintf(fil2,"%cinclude = %s\n",9,fn);

	return smb;
}


/*
 * Read main smb.conf / include .conf files
 */

void smbread(char *conffile,FILE *fil,int level,Form *form,FILE *fil2,int action,char *astr)
{
	FILE *fil3;	/* include file(s) */
	FILE *fil4;
	SMBCONF *section = NULL,*smb;
	OPTION *o;
	SECTION *current = NULL,*se,*sec;
	PARAM *p,*p2;
	OP *op;
	Parse *pa;
	char slask[500];
	char ord[500];
	char param[500];
	char value[500];
	char form_section[100];
	char temp[100];
	char oldname[100];
	char filename[100];
	short sectiontype = -1;
	short in_form = 0; /* in target section */
	short delete_this_section = 0;
	short empty_line = -1; /* don't add an empty line in beginning of conf file */
	short x;
	short this_section_num;
	short form_sectionnum;
/* actions */
	short a_modify = 0;
	short a_addopt = 0;
	short a_delopt = 0;
	short a_copyshare = 0;
	short a_delshare = 0;

	pa = new Parse(conffile,"/");
	pa -> getsplit(slask);
	while (*slask)
	{
		strcpy(filename,slask);
		pa -> getsplit(slask);
	}
	delete pa;

	switch (action)
	{
		case ACTION_MODIFY:
			a_modify++;
			break;
		case ACTION_ADDOPT:
			a_addopt++;
			break;
		case ACTION_DELOPT:
			a_delopt++;
			break;
		case ACTION_COPYSHARE:
			a_copyshare++;
			break;
		case ACTION_DELSHARE:
			a_delshare++;
			break;
	}

	if (form)
	{
		form -> getvalue("section",form_section);
		form -> getvalue("sectionnum",slask);
		form_sectionnum = atoi(slask);
	} else
	{
		*form_section = 0;
		form_sectionnum = -1;
	}

	fget(slask,500,fil);
	while (slask[strlen(slask) - 1] == '\\' && !feof(fil))
		fget(slask + strlen(slask) - 1,500 - strlen(slask),fil);
	while (!feof(fil))
	{
		pa = new Parse(slask);
		pa -> getword(ord);
		switch (*ord)
		{
			case ';':
			case '#':
			/* '### ' section info line */
				if (!strncmp(slask,"### ",4))
				{
					pa -> getword(ord);
					while (*ord)
					{
						if (!strcmp(ord,"sectiontype"))
						{
							pa -> getword(ord);
							sectiontype = atoi(ord);
						}
						pa -> getword(ord);
					}
					/* leave empty_line untouched */
				} else
				{
					add_comment(level,slask,fil2,this_section_num);
					empty_line = 0;
				}
				break;
			case '[': /* New section ... END OF SECTION */
				/* check if we're supposed to add an option to current section */
				/* also check this at end of file */
				if (a_addopt && in_form && *astr && *astr != ' ')
				{
					o = name2option(astr);
					if (o)
					{
						if (!o -> inplace)
						{
							op = get_option_info(astr);
							if (op -> type != OPTYPE_NOTFOUND)
							{
								add_comment(level,"; *** option added by configuration",fil2,this_section_num);
								smb = add_paramvalue(level,op -> realname,op -> def,fil2,this_section_num);
								add_emptyline(level,fil2,this_section_num);
								empty_line = 1;
								*astr = 0;
								if (current) /* don't include 'include' in param list */
								{
									p = new PARAM;
									p -> param = smb;
									addlistparam(&current -> parambase,p);
								}
							}
						}
					}
				}

				*oldname = 0; /* not renamed */
				if (!empty_line && fil2)
					fprintf(fil2,"\n");
				delete_this_section = 0; /* leaving old section, reset some variables */
				section = NULL;
				in_form = 0;
				this_section_num = section_num++;
				if (sectiontype == -1)
				{
					if (!strncasecmp(slask,"[global]",8))
						sectiontype = 0;
					else
					if (!strncasecmp(slask,"[homes]",8))
						sectiontype = 1;
					else
					if (!strncasecmp(slask,"[printers]",8))
						sectiontype = 2;
					else
						sectiontype = 4; /* other shares */
				}
				if (form)
					if (this_section_num == form_sectionnum) //!strcmp(slask,form_section))
					{
						form -> getvalue("sectiontype",temp);
						sectiontype = atoi(temp);
						in_form = 1;
						if (a_modify) /* change share name */
						{
							if (form -> getvalue("sharename",temp))
								if (strcmp(temp,slask) &&
								    *temp == '[' &&
								    temp[strlen(temp) - 1] == ']')
								{
									strcpy(oldname,slask);
									strcpy(slask,temp);
								}
						}
					}
				if (a_delshare && *astr && !strcmp(slask,astr))
					delete_this_section++;

				if (delete_this_section)
				{
					*slask = '#';
					strcat(slask," --- deleted by configuration");
					add_comment(level,slask,fil2,this_section_num);
				} else
				{
					section = add_section(level,slask,fil2,sectiontype,this_section_num,filename);
					if (*oldname) /* renamed */
					{
						section -> str2 = new char[strlen(oldname) + 1];
						strcpy(section -> str2,oldname);
					}
					sectiontype = -1;

					current = new SECTION;
					current -> section = section;
					current -> parambase = NULL;
					addlistsection(&sectionbase,current);
				}
				empty_line = 0;
				break;
			case 0: /* empty line */
				add_emptyline(level,fil2,this_section_num);
				empty_line = 1;
				break;

			default:
				strcpy(param,ord);
				pa -> getword(ord);
				while (*ord && *ord != '=')
				{
					strcat(param," ");
					strcat(param,ord);
					pa -> getword(ord);
				}
				if (*ord == '=')
				{
					pa -> getrest(value);
					if (a_modify && form && in_form) /* replace values with new values from form */
					{
						sprintf(ord,"line%d",linecount);
						if (form -> getvalue(ord,slask))
						{
							strcpy(value,slask);
						}
					}

					if (delete_this_section)
					{
						sprintf(slask,"#	%s = %s",param,value);
						add_comment(level,slask,fil2,this_section_num);
					} else
					{
						if (!strcasecmp(param,"include"))
						{
							if ((fil3 = fopen(value,"rt")) != NULL)
							{
								x = current_sectiontype;
								smb = add_include(level,value,"OK",fil2,this_section_num);
								if (form)
								{
									strcpy(slask,value);
									strcat(slask,"-mod");
									fil4 = fopen(slask,"wt");
								} else
									fil4 = NULL;
								smbread(value,fil3,level + 1,form,fil4,action,astr);
								fclose(fil3);
								if (form)
								{
/* copy share */
									if (action == ACTION_COPYSHARE && *astr)
									{
						for (se = sectionbase; se; se = se -> next)
							if (!strcmp(se -> section -> str1,astr))
								break;
						if (se)
						{
							strip(astr,slask);
							sprintf(astr,"[%s-copy]",slask);
							smb = add_section(0,astr,fil4,se -> section -> sectiontype,-1,value);
							sec = new SECTION;
							sec -> section = smb;
							sec -> parambase = NULL;
							addlistl(&sectionbase, (LIST *)sec);
							for (p = se -> parambase; p; p = p -> next)
							{
								smb = add_paramvalue(0,p -> param -> str1,p -> param -> str2,fil4,-1);
								p2 = new PARAM;
								p2 -> param = smb;
								addlistl(&sec -> parambase, (LIST *)p2);
							}
							add_emptyline(0,fil4,-1);
							*astr = 0;
						}
									}
									fclose(fil4);
									strcpy(slask,value);
									strcat(slask,"~");
									rename(value,slask);
									strcpy(slask,value);
									strcat(slask,"-mod");
									rename(slask,value);
								}
								current_sectiontype = x;
							} else
								smb = add_include(level,value,"ERROR",fil2,this_section_num);
						} else
						{
							if (a_delopt && in_form && *astr && !strcmp(astr,param))
							{
								sprintf(slask,"#	%s = %s",param,value);
								add_comment(level,slask,fil2,this_section_num);
								*astr = 0;
							} else
							{
								smb = add_paramvalue(level,param,value,fil2,this_section_num);

								if (current) /* don't include 'include' in param list */
								{
									p = new PARAM;
									p -> param = smb;
									addlistparam(&current -> parambase,p);
								}
							}
						}

						if (in_form) /* remember options used in section */
						{
							o = name2option(param);
							if (o)
								o -> inplace++;
						}
					} /* !delete_this_section */
				} else
				{
					printf("Huh? '%s'\n",slask);
					exit(-1);
				}
				empty_line = 0;
				break;
		}
		delete pa;
		fget(slask,500,fil);
		while (slask[strlen(slask) - 1] == '\\' && !feof(fil))
			fget(slask + strlen(slask) - 1,500 - strlen(slask),fil);
	} /* while (!feof) */

	/* check if we're supposed to add an option to current section */
	if (a_addopt && in_form && *astr && *astr != ' ')
	{
		o = name2option(astr);
		if (o)
		{
			if (!o -> inplace)
			{
				op = get_option_info(astr);
				if (op -> type != OPTYPE_NOTFOUND)
				{
					add_comment(level,"; *** option added by configuration",fil2,this_section_num);
					smb = add_paramvalue(level,op -> realname,op -> def,fil2,this_section_num);
					add_emptyline(level,fil2,this_section_num);
					empty_line = 1;
					*astr = 0;
					if (current) /* don't include 'include' in param list */
					{
						p = new PARAM;
						p -> param = smb;
						addlistparam(&current -> parambase,p);
					}
				}
			}
		}
	}

	/* conf file should end with an empty line */
	if (!empty_line && fil2)
		fprintf(fil2,"\n");
}

void smbreadfile(char *fn,Form *form,int action,char *astr)
{
	FILE *fil;
	FILE *fil2;
	SECTION *se,*sec;
	PARAM *p,*p2;
	SMBCONF *smb;
	char slask[200];

	if ((fil = fopen(fn,"rt")) != NULL)
	{
		if (form)
		{
			strcpy(slask,fn);
			strcat(slask,"-mod");
			fil2 = fopen(slask,"wt");
		} else
			fil2 = NULL;
		smbread(fn,fil,0,form,fil2,action,astr);
		fclose(fil);

	/* check to see if we should copy a share */

		if (form) /* close fil2 */
		{
			if (action == ACTION_COPYSHARE && *astr)
			{
				for (se = sectionbase; se; se = se -> next)
					if (!strcmp(se -> section -> str1,astr))
						break;
				if (se)
				{
					strip(astr,slask);
					sprintf(astr,"[%s-copy]",slask);
					smb = add_section(0,astr,fil2,se -> section -> sectiontype,-1,fn);
					sec = new SECTION;
					sec -> section = smb;
					sec -> parambase = NULL;
					addlistl(&sectionbase, (LIST *)sec);
					for (p = se -> parambase; p; p = p -> next)
					{
						smb = add_paramvalue(0,p -> param -> str1,p -> param -> str2,fil2,-1);
						p2 = new PARAM;
						p2 -> param = smb;
						addlistl(&sec -> parambase, (LIST *)p2);
					}
					add_emptyline(0,fil2,-1);
					*astr = 0;
				}
			}
			fclose(fil2);
			strcpy(slask,fn);
			strcat(slask,"~");
			rename(fn,slask);
			strcpy(slask,fn);
			strcat(slask,"-mod");
			rename(slask,fn);
		}
	} else
		printf("Couldn't open '%s'...\n",fn);
}


