/* $Id: axfr.c,v 0.8 1998/09/27 05:18:14 gaius Exp $ /*

/* -- System headers -- */
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>

/* -- Local headers -- */
#include "error.h"
#include "getopt.h"
#include "getaxfr.h"
#include "string.h"
#include "stdlib.h"
#include "config.h"

/* -- Macros -- */
#define AXFR_DIR "/axfrdb"

/* -- Pthreads -- */

/* -- File scope variables -- */
int debug = 0;
int dont_recurse = 0;
char *axfrhome = NULL;
char *directory = NULL;
char *hosts_d = NULL;
char *zone_d = NULL;
static char *progname;

/* -- External variables -- */
extern char *optarg;
extern int optind, opterr, optopt;

/* -- Structures and unions -- */
/* Getopt */
#define OPT_CHARS "dhvnD:f:P:t:s:"

struct option longopts[] =
{
  {"debug", optional_argument, 0, 'd'},
  {"help", no_argument, 0, 'h'},
  {"version", no_argument, 0, 'v'},

  {"directory", required_argument, 0, 'D'},
  {"file", required_argument, 0, 'f'},
  {"dont-recurse", no_argument, 0, 'n'},
  {"server", required_argument, 0, 's'},
  {0, 0, 0, 0}
};

/* -- External functions -- */

/* -- Functions -- */
static void showhelp ();

/* -- Signal catching functions -- */

/* -- Main -- */

int
main (int argc, char **argv)
{
  int dot = 0;
  int index = 0;
  int optc = 0;
  int lose = 0;
  int show_help = 0;
  int version = 0;
  int result = 0;
  char *server = NULL;		/* getopt */
  char *domainname = NULL;	/* argv */
  struct domain_s *domain;
  struct stat stat_buf;

  progname = argv[0];                                                           
  if (progname && strrchr(progname, '/'))                                       
    progname = strrchr(progname, '/') + 1;                                      

  while ((optc = getopt_long (argc, argv, OPT_CHARS, longopts, (int *) 0)) != EOF)
  {
    switch (optc)
    {
    case 'd':
      debug++;
      break;
    case 'h':
      show_help = 1;
      break;
    case 'v':
      version = 1;
      break;
    case 'D':
      directory = optarg;
      break;
    case 'n':
      dont_recurse = 1;
      break;
    case 's':
      server = optarg;
      break;
    default:
      lose = 1;
    }
  }

  if (show_help)
  {
    showhelp();
    exit(0);
  }

  if (version)
  {
    printf("%s version %s by gaius\n\
Copyright (C) 1997, 1998 Rostra design.\n\
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n\
PARTICULAR PURPOSE.\n\n", PACKAGE, VERSION);
    exit(0);
  }

  argv += optind;
  argc -= optind;

  if (*argv == NULL || lose)
  {
  (void) fprintf(stderr, "Usage: %s [options] domain...\n\
Try  %s --help' for more information.\n", progname, progname);
    exit (1);
  }
    if (strcmp(".", *argv+(strlen(*argv))-1) != 0)
      dot = 1;
 
  if (directory)
    (void) fprintf(stderr, "%s: Using user defined directory: %s\n", progname, directory);
  else
  {
    directory = getenv("AXFR_HOME");
    if (directory)
      (void) fprintf(stderr, "%s: Using AXFR_HOME environment: %s\n", progname, directory);
    else
    { /* Use default */
      directory = alloca(strlen(getenv("HOME")) + strlen(AXFR_DIR) + 1);
      strcpy(directory, getenv("HOME"));
      strcat(directory, AXFR_DIR);
      (void) fprintf(stderr, "%s: Using default directory: %s\n", progname, directory);
    }
  }
  /* Change dir to axfr home */
    if(chdir(directory) != 0)
    {
        (void) fprintf(stderr, "%s: Making directory: %s\n", progname, directory);
        if (mkdir(directory, DIR_PERM))
          fatal("Can't make directory:");
        if (chdir(directory))
          fatal("Can't change dir to %s", directory);
    }

  hosts_d = alloca(strlen(directory) + strlen("/hosts")+ 1); 
  zone_d = alloca(strlen(directory) + strlen("/zone")+ 1); 
  sprintf (hosts_d, "%s/hosts", directory);
  sprintf (zone_d, "%s/zone", directory);
  mkdir(hosts_d, DIR_PERM);
  mkdir(zone_d, DIR_PERM);
  
  while (argc--) /* xxx make it unique */
  {
    domainname = (char *) alloca (strlen (*argv) + 1 + dot);
    if (!domainname)
      fatal ("alloca(domainname)");
    (void) strcpy (domainname, *argv);
    if (dot)
      (void) strcat (domainname, ".");
  
    domain = getaxfrbydomainname(domainname, NULL);
    /* xxx option to print domain tree from struct */
    delete_domain(domain);
    argv++;
  }
  
  exit (0);
}

static void showhelp ()
{
  (void) printf("Usage: %s [options] domain...\n\
Options:\n\
  -d, --debug                 Print lots of debugging information.\n\
  -h, --help                  Print this message and exit.\n\
  -v, --version               Print the version number of %s and exit.\n\
  -D, --directory             Set default %s directory.\n\
  -s, --server                Set default name server.\n\
  -n, --dont-recurse          Disable recursion\n", progname, progname, progname);
  fflush(stdout);
  fflush(stderr);
}

/* Get Put Undo Redo Split Snarf make clean */
