/* $Id: error.c,v 0.7 1998/09/27 05:18:15 gaius Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include <string.h>


static void _cmnerr (const char *fmt, va_list ap);


void
error (const char *fmt,...)
{
  va_list ap;

  va_start (ap, fmt);
  _cmnerr (fmt, ap);
  va_end (ap);
}

static void
_cmnerr (const char *fmt, va_list ap)
{
  int err;

  err = errno;

  vfprintf (stderr, fmt, ap);
  if (err != 0)
    fprintf (stderr, ": %s", strerror (err));
  putc ('\n', stderr);
}

void
fatal (const char *fmt,...)
{
  va_list ap;
  va_start (ap, fmt);
  _cmnerr (fmt, ap);
  va_end (ap);
  exit (1);
}
