/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *   Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: cbc-frame.h,v 1.9 1999/01/31 18:12:35 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 */

#ifndef __CBC_FRAME_H__
#define __CBC_FRAME_H__

/* Size of a plain text data packet that can be read all at once */
#define	CBC_IO_BUFLEN       1024

/* Minimal and maximal the buflen can be resized, to */
#define	CBC_IO_BUFLEN_MIN    128
#define	CBC_IO_BUFLEN_MAX  (1024 << 4)

/* maximal number of active channel threads (at most USHORT_MAX) */
#define	CBC_THREADS_MAX      128 /* default value */
#define	CBC_THREADS_LIMIT    256 /* can be extended to that limit */

/* set the default interval when the session key needs to be changed */
#define	CBC_KEYTTL_SECS      120 /* set it 0 to disable */

#include "cipher.h"
#include "iostream.h"

/* public functions ... */
extern char *cbc_get_info 
  (unsigned is_sender, size_t *contextsize,
   int (**cbc_open) (void *, unsigned fd, cipher_desc*, frame_desc*, char[4]),
   int (**cbc_rdwr) (void *, char *, unsigned, int flg),
   int (**cbc_ioctl)(void *, io_ctrl_request, int*),
   void(**cbc_close)(void *));

#endif /* __CBC_FRAME_H__ */
