/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *    Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: common-stuff.h,v 1.11 1999/01/31 12:36:49 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __COMMON_STUFF_H__
#define __COMMON_STUFF_H__

/* ----------------------------------------------------------------------- *
 *                  begin of configurable section                          *
 * ----------------------------------------------------------------------- */

extern void *emalloc (unsigned long), efree (void *);

/* The malloc () replacement here returns 0-initialized space, never ever 
   returns NULL.  Unless you do not have your own memroy manager, create
   something like:
   void *myalloc(int n) {void *p=calloc(1,n); assert(p!=0); return p;} */

#define XMALLOC(x)	(void*)emalloc (x)
#define XFREE(x)	efree (&(x)) /* reference due to implementation */

/* should apply to most OSs */
#ifndef HAVE_NO_ALIGN  
#ifndef HAVE_U64ALIGN  
#define HAVE_U32_ALIGN  1 /* say: can align u32 on int boundary */
#endif
#endif

/* All we need here is an independent send/reveive structure provided by
   the operating system */

#define OS_SEND(fd,buf,len,flg) send (fd, buf, len, flg)
#define OS_RECV(fd,buf,len,flg) recv (fd, buf, len, flg)

/* ----------------------------------------------------------------------- *
 *                    end of configurable section                          *
 * ----------------------------------------------------------------------- */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#else
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h>
# endif
#endif
#if STDC_HEADERS
# include <string.h>
# include <stdlib.h>
#else
# ifdef HAVE_STRING_H
#  include <string.h>
# endif
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
# ifdef HAVE_MEMORY_H
#  include <memory.h>
# endif
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
  char *strchr (), *strrchr ();
# ifdef HAVE_BCOPY  
#  ifndef HAVE_MEMCPY
#   define memcpy(d, s, n) bcopy ((s), (d), (n))
#  endif
#  ifndef HAVE_MEMMOVE
#   define HAVE_MEMMOVE
#   define memmove(d, s, n) bcopy ((s), (d), (n))
#  endif
# endif
# ifdef HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <limits.h>

#if SIZEOF_UNSIGNED_INT == 4
  typedef unsigned int u32;
#elif SIZEOF_UNSIGNED_LONG == 4
  typedef unsigned long u32;
#else
# error no typedef for u32
#endif

/* AIX requires this to be the first thing in the file.  */
#ifdef __GNUC__
# if !defined (_ALLOCA_H) && !defined (alloca)
# define alloca __builtin_alloca
# endif
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#   pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
     char *alloca ();
#   endif
#  endif
# endif
#endif

#ifdef HAVE_ALLOCA
#define ALLOCA(x)	alloca (x)
#define DEALLOCA(x)	/* not needed */
#else
#define ALLOCA(x)	XMALLOC (x)
#define DEALLOCA(x)	XFREE (x)
#endif

/* duplicate string, based on secure alloc or alloca */
#define XSTRDUP(s)	strcpy (XMALLOC (strlen (s) + 1), (s))
#define ALLOCASTRDUP(s)	strcpy  (ALLOCA (strlen (s) + 1), (s))

#endif /* __COMMON_STUFF_H__ */
