/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *    Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: hostnames.c,v 1.7 1999/01/31 12:36:43 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/* NOTE: inet_ntoa might not be thread save ! */

#include "common-stuff.h"
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#else
# include <socket.h> /* ????? */
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif

/* ---------------------------------------------------------------------------- *
 *                      private helpers                                         *
 * ---------------------------------------------------------------------------- */

/* should be initialized in a threaded environment */
static const char *
get_myself (void)
{
  /* hold name for localhost */
  static char *myself;

  if (myself == 0) { 
    char buf [1024] ;
    if (gethostname (buf, sizeof (buf)) == 0)
      myself = XSTRDUP (buf) ;
  }
  
  return myself ;
}


static int
is_ip_pattern
  (const char *s)
{
  int n ;

  if ('1' <= *s && *s <= '9') {
    s ++ ;
    n = 2;
    while (n -- > 0 && '0' <= *s && *s <= '9') 
      s ++ ;
  }
  if (*s ++ != '.')
    return 0 ;

  if ('1' <= *s && *s <= '9') {
    s ++ ;
    n = 2;
    while (n -- > 0 && '0' <= *s && *s <= '9') 
      s ++ ;
  }
  if (*s ++ != '.')
    return 0 ;

  if ('1' <= *s && *s <= '9') {
    s ++ ;
    n = 2;
    while (n -- > 0 && '0' <= *s && *s <= '9') 
      s ++ ;
  }
  if (*s ++ != '.')
    return 0 ;

  if ('1' <= *s && *s <= '9') {
    s ++ ;
    n = 2;
    while (n -- > 0 && '0' <= *s && *s <= '9') 
      s ++ ;
  }
  
  return *s == '\0' ;
}

/* ---------------------------------------------------------------------------- *
 *                      compare host names                                      *
 * ---------------------------------------------------------------------------- */

/* returns sort of a canonical host name */
const char *
get_host_ip
   (const char *name)
{
  struct hostent *h;
  struct in_addr in;
  
  if (name == 0 && (name = get_myself ()) == 0)
    return 0 ;
  
  if (is_ip_pattern (name))
    return name ;
  
  if ((h = gethostbyname (name)) == 0)
    return 0 ;

  /* convert to ip address */
  memcpy (&in.s_addr, *h->h_addr_list, h->h_length); 

  /* NOTE: inet_ntoa might not be thread save ! */
  return XSTRDUP (inet_ntoa (in));
}

int
hostnomatch
  (const char *pattern,
   const char   *entry,
   size_t          len)
{
  return -1 ;
}


int
hostcmp
  (const char *pattern,
   const char   *entry,
   size_t          len)
{
  char buf [1024], pattern_ip [20], entry_ip [20] ;
  struct hostent *h;
  struct in_addr in;

  /* quick check for impossible hostnames */
  if (*entry == '#' || *entry == '@')
    return -1 ;

  /* this is easy, is it not ? */
  if (len <= 0) {
    if (strcasecmp (pattern, entry) == 0)
      return 0;
    
  } else {
    if (strncasecmp (pattern, entry, len) == 0)
      return 0;
    /* need to cut the entry string */
    if (len >= sizeof (buf) - 1)
      return -1 ;
    memcpy (buf, entry, len) ;
    buf [len] = '\0' ;
    entry = buf ;
  }

  /* we resolve pattern, here */
  if ((h = gethostbyname (pattern)) == 0)
    return -1 ;
  /* convert to ip address */
  memcpy (&in.s_addr, *h->h_addr_list, h->h_length); 
  
  /* NOTE: inet_ntoa might not be thread save ! */
  strcpy (pattern_ip, inet_ntoa (in));
    
  /* resolve entry, now */
  if ((h = gethostbyname (entry)) == 0)
    return -1 ;
  /* convert to ip address */
  memcpy (&in.s_addr, *h->h_addr_list, h->h_length); 
     
  /* NOTE: inet_ntoa might not be thread save ! */
  strcpy (entry_ip, inet_ntoa (in));

  return strcmp (pattern_ip, entry_ip);
}
