/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *       Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: iostream.h,v 1.10 1999/01/31 12:36:49 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   --------------------------------------------------------------------
 *   This module sets a generic layer on top of the standard io functions
 *   like send, recv, read and write.  It replaces the channel numbers by
 *   a generic descriptor and calls the approriate io functions.
 */


#ifndef __IOSTREAM_H__
#define __IOSTREAM_H__

/* control requests to be passed to the io_ctrl () function defined, below.
   As a general rule, a successful request returns a non-negative value. Upon
   error, -1 is returned while the global variable errno is set to some value
   indicating the error type. */

typedef enum {

  IO_RESIZE_BUF,		           /* arg is (int*)buffer_size, or 0 */
  IO_CHANGE_KEY,	                  /* arg is (int*)key_schedule, or 0 */
  IO_REGISTER_THREAD,		 /* prepare threaded channel, arg is ignored */
  IO_ACTIVATE_THREAD,		 /* open channel, arg is (int*)threadID or 0 */
  IO_UNLINK_THREAD,    /* close thread on sender, arg is (int*)threadID or 0 */
  IO_DESTROY_THREAD,   /* close threaded channel, arg is (int*)threadID or 0 */
  IO_UNLINK_THREAD_PID,	    /* close thread on sender, arg is (int*)PID or 0 */
  IO_DESTROY_THREAD_PID,    /* close threaded channel, arg is (int*)PID or 0 */
  IO_PUBLIC_DESTROY,        /* everybody can destroy, arg is (int*)BOOL or 0 */
  IO_SYNTHETIC_PID,	     /* substitutes getpid (), arg is (int*)PID or 0 */
  IO_MAX_THREADS,	   /* set max num of threads, arg is (int*)MAX, or 0 */
  IO_STOPONEMPTY_STATE,	  /* set stop-on-empty flag, arg is (int*)BOOL, or 0 */
  IO_EOF_STATE,			    /* set eof flag, arg is (int*)BOOL, or 0 */
  IO_TOTAL_COUNTER, /* get/set total protocol data bytes, arg is (int*) or 0 */
  IO_PAYLOAD_COUNTER, /* get/set user payload data bytes, arg is (int*) or 0 */
  IO_FLUSH_CACHE		    /* flush any data not yet processed, yet */

} io_ctrl_request ;


/* layer create/destroy management */
extern void  io_pop (unsigned fd, unsigned how) ;
extern void *io_push  /* never returns NULL */
  (unsigned fd, 
   unsigned contextsize, 
   int  (*rdwr_fn)   (void *, char *msg, unsigned len, int flags),
   int  (*ioctl_fn)  (void *, io_ctrl_request, int *arg),
   void (*destroy_fn)(void *), 
#  define IO_PUSH_EXCLUSIVELY 4 /* XORed to the last argument "how" */
   unsigned how);

/* some generic control function passing, the last argument is either 0, or
   1, where 0 == receiver, 1 == sender. */
extern int io_ctrl (unsigned, io_ctrl_request, int *, unsigned) ;


/* start/stop (default == start) management, the last argument is either 0, 1, or
   2 where 0 == receiver, 1 == sender, 2 == both. */
extern void  io_enable (unsigned fd, unsigned how) ;
extern void io_suspend (unsigned fd, unsigned how) ;


/* io top layer functions, emulates send/recv/shutdown */
extern int io_send     (unsigned fd, const char *buf, unsigned len, unsigned flags);
extern int io_recv     (unsigned fd,       char *buf, unsigned len, unsigned flags);
extern int io_shutdown (unsigned fd, unsigned how);
extern int io_close    (unsigned fd);


/* replacement for network read/write functions */
#ifndef __IOSTREAM_PRIVATE__
#define send(fd, buf, n, flg)   io_send (fd, buf, n, flg)
#define recv(fd, buf, n, flg)   io_recv (fd, buf, n, flg)
#define shutdown(fd,flg)        io_shutdown (fd, flg)
#define close(fd)               io_close (fd)
#endif

#ifdef DUMP_IOLAYER /* for debugging */
extern int dump_send, dump_recv, iodebug_flags ;
#endif

#endif /* __IOSTREAM_H__ */
