/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *   Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: messages.h,v 1.12 1999/01/31 12:36:50 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   PEKS - private exponent key stuff for Diffie Hellman and El Gamal
 */

#ifndef __MESSAGES_H__
#define __MESSAGES_H__


/* some magic */
#define _arg1of2(x,y) x
#define _arg2of2(x,y) y


/* extract value from error symbol */
#define errnum(sym)  (sym (_arg1of2) + 20000)
#define errstr(sym)   sym (_arg2of2)


/* concise list of all error symbols */
#define PEKS_ERRLIST1(f)							\
	f(CANT_OPEN_KEY_RFILE) f(CANT_OPEN_KEY_WFILE) f(KEYFILE_PARSER_ERR)	\
        f(FUNCTION_ARG_ERROR) f(NO_SYMLINK_WANTED) f(REG_FILE_WANTED)		\
        f(NOT_GROUP_WRITABLE) f(NOT_WORLD_READABLE) f(NOT_GROUP_READABLE)	\
        f(KEY_FILE_EXISTS) f(CANT_EXPAND_FNAME)	f(SERVER_SPOOF_ALERT)		\
	f(STORED_SERVER_KEY) f(TOO_MANY_PRIME_TRIES) f(	MODIFIED_KEY_TAG)	\
        f(LINE_PARSER_ERR) f(LINE_PARSER_CRCERR) f(LINE_PARSER_B64ERR)

#define PEKS_ERRLIST2(f)							\
        f(ELG_TEXT_2LONG) f(ELG_B64TEXT_ERR)					\
        f(PEKS_PROTO_ERROR) f(PEKS_SYNTAX_ERROR)				\
	f(RESP_VERS_MISMATCH) f(RESP_PUBKEY_MISSING)				\
	f(RESP_CODE_MISSING) f(RESP_CRC_MISSING) f(RESP_2MANY_FIELDS)		\
	f(RESP_CRCVAL_ERR) f(RESP_PUBKEY_ERR) f(RESP_PAYLOAD_ERR)

#define PEKS_ERRLIST3(f) f(ACCEPT_PUBKEY_ERR) f(DECODE_SRVKEY_ERR)		\
	f(DECODE_NO_CIPHER) f(DECODE_CLNTKEY_ERR)				\
        f(SRV_SETUP_SKEY) f(SRV_CLIENT_KNOCKING) f(SRV_CLIENT_RESPERR)		\
        f(SRV_MAGIC_FAILED) f(SRV_WRONG_MAGIC) f(CLNT_MAGIC_FAILED)		\
        f(CBC_RECV_NULL_BLOCK) f(CBC_RECV_LEN_2SMALL) f(CBC_RECV_LEN_2LARGE)	\
        f(CBC_RECV_LEN_NOBNDRY) f(CBC_RECV_UNEXP_EOF) f(CBC_RECV_CRCERR)

#define PEKS_ERRLIST4(f)							\
        f(CBC_CACHERES_BLOCKED) f(CBC_UNKNOWN_CTL) f(CBC_NULL_CTLARG)		\
        f(CBC_NOSUCH_THREADID) f(CBC_NOSUCH_COOKIE) f(CBC_CTL_SENDER_ONLY)	\
        f(CBC_CTL_RECV_ONLY) f(CBC_REC_ILL_THREADID) f(CBC_REC_NO_THREADID)	\
	f(CBC_NO_MORE_THREADS) f(CBC_ILL_THREADID) f(CBC_ILL_SUBCMD)		\
	f(CBC_UNSUPPORTED_BLEN)	f(CBC_UNSUPPORTED_KLEN)				\
        f(CBC_CANT_KILL_NOTOWN) f(IOST_SEND_RECV_ONLY)				\
        f(IOST_NO_RECV_IOLFN) f(IOST_NO_SEND_IOLFN)				\
        f(IOST_NO_RECV_CTLFN) f(IOST_NO_SEND_CTLFN) f(IOST_EEXISTS)



/* peks-file.c error symbols */
#define CANT_OPEN_KEY_RFILE(f)	f( 1, "Can't open key file for reading")
#define CANT_OPEN_KEY_WFILE(f)	f( 2, "Can't open key file for writing")
#define KEYFILE_PARSER_ERR(f)	f( 3, "Illegal lines in key file")
#define FUNCTION_ARG_ERROR(f)   f( 4, "Got illegal function arguments (internal)")
#define NO_SYMLINK_WANTED(f)    f( 5, "File must not be a symbolic link")
#define REG_FILE_WANTED(f)      f( 6, "File must be regular, neither a pipe, nor a device")
#define NOT_GROUP_WRITABLE(f)   f( 7, "File must neither be world, nor group writable")
#define NOT_WORLD_READABLE(f)   f( 8, "File must not be world readable")
#define NOT_GROUP_READABLE(f)   f( 9, "File must neither be world, nor group readable")
#define KEY_FILE_EXISTS(f)      f(10, "Attempt to overwrite existing key file")
#define CANT_EXPAND_FNAME(f)    f(11, "Cannot expand key file name ($HOME missing ?)")
#define SERVER_SPOOF_ALERT(f)   f(12, "Spoof alert: Server public key has changed")
#define STORED_SERVER_KEY(f)    f(13, "Host key for that server has been saved")
#define MODIFIED_KEY_TAG(f)     f(14, "A special purpose key entry has been modified")

/* peks-setup.c error symbols */
#define LINE_PARSER_ERR(f)	f(31, "Syntax error in the key setup line")
#define LINE_PARSER_CRCERR(f)	f(32, "CRC error in the key setup line")
#define LINE_PARSER_B64ERR(f)	f(33, "Some field in the key setup line is not base 64")
#define TOO_MANY_PRIME_TRIES(f)	f(34, "Can't generate prime/generator - tried too often") 

/* peks-handshake.c error symbols */
#define ELG_TEXT_2LONG(f)	f(41, "Argument text longer than prime module")
#define ELG_B64TEXT_ERR(f)	f(42, "Can't convert text to base 64 numeric (internal)") 
#define PEKS_PROTO_ERROR(f)     f(43, "Unsupported protocol version, used")
#define PEKS_SYNTAX_ERROR(f)    f(44, "Syntax error in peks protocol line")
#define RESP_VERS_MISMATCH(f)	f(51, "Unacceptable version string in the respose text")
#define RESP_PUBKEY_MISSING(f)	f(52, "Missing 1st public key field in the response text")
#define RESP_CODE_MISSING(f)	f(53, "Missing 2nd code field in the response text")
#define RESP_CRC_MISSING(f)	f(54, "Missing 3rd crc field in the response text")
#define RESP_2MANY_FIELDS(f)	f(55, "More than 3 fields in the response text")
#define RESP_CRCVAL_ERR(f)	f(56, "Crc verification of the response text failed")
#define RESP_PUBKEY_ERR(f)	f(57, "No base64 coded public key wrapped in the response")
#define RESP_PAYLOAD_ERR(f)	f(58, "No base64 coded response text or key")

/* peks-client.c error symbols */
#define ACCEPT_PUBKEY_ERR(f)	f(61, "Can't decode public server key message")
#define DECODE_SRVKEY_ERR(f)	f(62, "Can't decode server key message")
#define CLNT_MAGIC_FAILED(f)	f(65, "Could not send magic string to server")

/* peks-server.c error symbols */
#define DECODE_NO_CIPHER(f)	f(72, "Client used wrong encryption type for prv key wrapper")
#define DECODE_CLNTKEY_ERR(f)	f(73, "Can't decode client key message")
#define SRV_SETUP_SKEY(f)	f(74, "Can't setup peks server key")
#define SRV_MAGIC_FAILED(f)	f(78, "Could not read magic string from client")
#define SRV_WRONG_MAGIC(f)	f(79, "Client sent incompatible magic string")
#define SRV_CLIENT_KNOCKING(f)	f(80, "Client was knocking at the door, only")
#define SRV_CLIENT_RESPERR(f)	f(81, "Initial client response was garbage")

/* cbc-frame.c error symbols */
#define CBC_RECV_NULL_BLOCK(f)	f( 91, "Received EOF when block was expected")
#define CBC_RECV_LEN_2SMALL(f)	f( 92, "Received block length value too small")
#define CBC_RECV_LEN_2LARGE(f)	f( 93, "Received block length value exceeds limit")
#define CBC_RECV_LEN_NOBNDRY(f)	f( 94, "Received block length value not on block boundary")
#define CBC_RECV_UNEXP_EOF(f)	f( 95, "Got EOF in the middle of a block read")
#define CBC_RECV_CRCERR(f)	f( 96, "CRC error")
#define CBC_CACHERES_BLOCKED(f)	f( 97, "Need to flush cache before resizing")
#define CBC_UNKNOWN_CTL(f)	f( 98, "Unknown control request")
#define CBC_NULL_CTLARG(f)      f( 99, "Null control argument pointer not useful")
#define CBC_NOSUCH_THREADID(f)  f(100, "There is no thread with the given ID")
#define CBC_NOSUCH_COOKIE(f)    f(101, "There is no thread for the received cookie")
#define CBC_CTL_SENDER_ONLY(f)  f(102, "This control request is sender, only")
#define CBC_CTL_RECV_ONLY(f)    f(103, "This control request is receiver, only")
#define CBC_NO_MORE_THREADS(f)  f(104, "Reached maximum limit of threads, already")
#define CBC_REC_ILL_THREADID(f) f(105, "Received wrong thread id in data block")
#define CBC_REC_NO_THREADID(f)  f(106, "Threaded data block without thread id")
#define CBC_ILL_THREADID(f)     f(107, "There is no thread assigned with the id, given")
#define CBC_ILL_SUBCMD(f)       f(108, "Received unknown sub command in data block")
#define CBC_UNSUPPORTED_BLEN(f) f(109, "CBC block length not supported for that cipher")
#define CBC_UNSUPPORTED_KLEN(f) f(110, "Key lenghts above 16 bytes are unsupported")
#define CBC_CANT_KILL_NOTOWN(f) f(111, "Cannot destroy someboy else's io thread")

/* iostream.c error symbols */
#define IOST_SEND_RECV_ONLY(f)  f(121, "Illegal direction arguments (0, or 1 only)")
#define IOST_EEXISTS(f)         f(122, "There has been a layer pushed, already")
#define IOST_NO_RECV_CTLFN(f)   f(123, "There was no receiver control fn, assigned")
#define IOST_NO_RECV_IOLFN(f)   f(124, "There was no receiver input fn, assigned")
#define IOST_NO_SEND_CTLFN(f)   f(125, "There was no sender control fn, assigned")
#define IOST_NO_SEND_IOLFN(f)   f(126, "There was no sender output fn, assigned")
#endif /* __MESSAGES_H__ */
