/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *   Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: peks-baseXX.c,v 1.7 1999/01/31 12:36:44 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common-stuff.h"

#ifdef HAVE_ASSERT_H
#include <assert.h>
#else
#define assert(x)   ((void*)0)
#endif

#include "peks-internal.h"
#include "peks-baseXX.h"
#include "baseXX.h"
#include "cipher.h"
#include "rnd-pool.h"


/* ---------------------------------------------------------------------------- *
 *                 private functions: crc stuff                                 *
 * ---------------------------------------------------------------------------- */

static void
sequenced_md 
  (char result [4],
   const  char *x1,
   const  char *x2,
   const  char *x3)
{
  static frame_desc *frame ;
 
  if (frame == 0) {
    frame = create_frame 
      (find_frame_class (PEKS_KEY_LINE_CRC_TYPE), PEKS_KEY_LINE_CRC_OFFS);
    assert (frame != 0);
  }
  
  XCRCFIRST (frame, x1, strlen (x1)) ;
  XCRCNEXT  (frame, " ", 1) ;
  XCRCNEXT  (frame, x2, strlen (x2)) ;
  if (x3 != 0) {
    XCRCNEXT  (frame, " ", 1) ;
    XCRCNEXT  (frame, x3, strlen (x3)) ;
  }

  memcpy (result, XCRCRESULT (frame), 4) ;
}

/* ---------------------------------------------------------------------------- *
 *                  public functions: crc stuff                                 *
 * ---------------------------------------------------------------------------- */

char *
seqB64_md 
  (const  char *x1,
   const  char *x2,
   const  char *x3)
{
  unsigned char buf [4] ;
  sequenced_md (buf, x1, x2, x3) ;
  return bin2base64 (buf, 4);
}


int
comp_seqB64_md 
  (const  char *b64in,
   const  char *x1,
   const  char *x2,
   const  char *x3)
{
  char *t = seqB64_md (x1, x2, x3) ;
  int   n = strcmp (b64in, t) ;
  XFREE (t);
  return n;
}

/* ---------------------------------------------------------------------------- *
 *                     public mumeric conversion functions                      *
 * ---------------------------------------------------------------------------- */

char*
mpz2base64
  (mpz_t *OP)
{
  char *t, *s = ALLOCA (mpz_sizeinbase (*OP, 32) + 2) ;

  POINT_OF_RANDOM_STACK (6) ;

  mpz_get_str (s, 32, *OP) ;
  t = baseXtoBase64 (s,5) ;
  DEALLOCA (s) ;
  return t;
}


unsigned
base64toMpz
  (mpz_t     *OP,
   const char *s)
{
  char *t ;
  int n;
  if (s == 0) {
    mpz_set_ui (*OP, 0);
    return 0;
  }

  t = base64toBaseX (s,5) ;
  POINT_OF_RANDOM_VAR (t);

  n = mpz_set_str (*OP, t, 32);
  POINT_OF_RANDOM_VAR (n);

  POINT_OF_RANDOM_STACK (8) ;

  XFREE (t);
  return !n; /* 1 is ok, 0 is error */
}


char*
uint2base64
  (unsigned long n)
{
  char buf [2 * sizeof (long) + 1];

  POINT_OF_RANDOM_STACK (13) ;

  sprintf (buf, "%lx", n) ;
  return baseXtoBase64 (buf,4) ;
}


unsigned long
base64toUint
  (const char *s)
{
  unsigned long num ;
  char *t, *u, c ;

  POINT_OF_RANDOM_STACK (12) ;

  if (s == 0)
    return UINT_MAX ;

  t = base64toBaseX (s,4) ;
  POINT_OF_RANDOM_VAR (t);

  num = strtol (t, &u, 16) ;

  c = *u ; /* save char, u points into t */
  XFREE (t) ;
  return c ? UINT_MAX : num ; 
}
 
