/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *   Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: peks-baseXX.h,v 1.5 1999/01/31 12:36:50 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   PEKS - private exponent key stuff for Diffie Hellman and El Gamal
 */

#ifndef __PEKS_BASE_XX_H__
#define __PEKS_BASE_XX_H__

#ifdef HAVE_GMP_H
#include <gmp.h>
#elif defined (HAVE_GMP2_GMP_H)
#include <gmp2/gmp.h>
#else
#include <gmp/gmp.h>
#endif

/* public functions in peks-baseXX.c */
extern char*         mpz2base64  (mpz_t *OP);
extern char*         uint2base64  (unsigned long);
extern unsigned      base64toMpz (mpz_t *OP, const char *);
extern unsigned long base64toUint (const char*);

/* message digest/crc handling */
extern char *seqB64_md (const char*, const char*, const char*);
extern int   comp_seqB64_md (const char*, const char*, const char*, const char*);


#endif /* __PEKS_BASE_XX_H__ */
