/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *   Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: peks-internal.h,v 1.8 1999/01/31 12:36:50 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   PEKS - private exponent key stuff for Diffie Hellman and El Gamal
 */

#ifndef __PEKS_INTERNAL_H__
#define __PEKS_INTERNAL_H__

#ifdef HAVE_GMP_H
#include <gmp.h>
#elif defined (HAVE_GMP2_GMP_H)
#include <gmp2/gmp.h>
#else
#include <gmp/gmp.h>
#endif

/* field separator chars, used when parsing tokens on line */
#define PEKS_FS           " \t\n"  

/* length used when there is no positive length parameter in 
   new_peks_key () or in peks_generate_modulus () */
#define DEFAULT_PRIME_BITS       1024

/* The tag that denotes the default key line definitition */
#define PEKS_SERVER_KEY_TAG    "@"

/* the hash algorithm that is used for key lines */
#define PEKS_KEY_LINE_CRC_TYPE  "md5"
#define PEKS_KEY_LINE_CRC_OFFS     3


typedef struct _peks_key {

  /* base values */
  mpz_t modulus ;	 /* prime p */
  mpz_t private ;	 /* prime q, or private exponent a */
  mpz_t common ;	 /* common key g^ab (mod p) */
  unsigned generator ;	 /* g (mod p) */

  enum {undefined = 0, 
	elg_encrypted, 
	plain_text} import_type ;

  /* base64 i/o values */
  char *modulus_str ;	/* p */
  char *generator_str;	/* g */
  char *export_key_str; /* public key */
  char *import_str;	/* client response text */

} peks_key ;

#include "peks.h"

/* some call back function type */
typedef int strncmp_fn (const char *, const char *, size_t) ;

/* public functions in hostnames.c */
extern strncmp_fn hostcmp ;
extern strncmp_fn hostnomatch ;
extern const char *get_host_ip (const char *name);

/* internal (but public) functions in peks-file.c */
extern peks_key *read_peks_key (const char *tag, strncmp_fn *, const char *file);
extern int       save_peks_key (peks_key *, const char *tag, strncmp_fn, const char *file);
extern int       check_peks_server_key (peks_key *, const char *host, const char *file);

/* internal (but public) functions in peks-setup.c */
extern peks_key *dup_peks_key (const peks_key *old);
extern peks_key *get_peks_key_from_str (const char *line);
extern void      end_peks_key (peks_key *key);
extern unsigned  peks_split_ident (const char *ident [], const char *, unsigned);
extern char     *make_peks_key_line (const char *tag,  const peks_key *key, 
				     const char *key_str, const char *term) ;

/* public functions in peks-handshake.c */
extern char     *make_public_key_str (peks_key *, const char *term) ;
extern peks_key *accept_public_key_str (const char *);
extern void      update_accepted_public_key_str (const char *line, peks_key *key);
extern char     *make_dh_response_key_str (peks_key *, const char *, const char *);
extern char     *make_elg_response_key_str (peks_key *, const char *, 
					    unsigned, const char *);
extern int       accept_response_key_str (peks_key *, const char *line);


#endif /* __PEKS_INTERNAL_H__ */
