/*
 *          Copyright (c) mjh-EDV Beratung, 1996-1998
 *     mjh-EDV Beratung - 63263 Neu-Isenburg - Rosenstrasse 12
 *          Tel +49 6102 328279 - Fax +49 6102 328278
 *                Email info@mjh.teddy-net.com
 *
 *       Author: Jordan Hrycaj <jordan@mjh.teddy-net.com>
 *
 *   $Id: peks.h,v 1.8 1999/01/31 12:36:51 jordan Exp $
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   PEKS - private exponent key stuff for Diffie Hellman and El Gamal
 */

#ifndef __PEKS_H__
#define __PEKS_H__

#ifndef __PEKS_INTERNAL_H__
typedef struct { char opaq [1] ; } peks_key ;
#endif

/* public functions in peks-setup.c */
extern char *    peks_version (void);
extern peks_key *new_peks_key (unsigned size);

/* public functions in peks-file.c */
extern peks_key *read_peks_server_keyfile (const char *file);
extern int     create_peks_server_keyfile (peks_key *, const char *file);

/* public functions in peks-strerr.c */
extern char *peks_strerr (unsigned n);

/* public functions in peks-client.c */
extern int client_negotiate_session_key 
    (const char *cipher, int socket, const char *client, 
     const char *keyfile) ;

/* public functions in peks-server.c, returns an error number, or 0 */
extern int server_negotiate_session_key 
    (peks_key *def_key, int socket, const char *server, const char *keyfile) ;

#endif /* __PEKS_H__ */
