/* Hostloop -- the Hostloop Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   
 
 
 
#ifndef __host_loop_h__
#define __host_loop_h__

/*
  				       HostsLoop System
		                 By Renaud Deraison <deraison@worldnet.fr>

	
*/

#ifndef NESSUSNT
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#define HL_NFS 1
#define HL_DNS 2
#define HL_IP  4
#define HL_PING 8
#define HL_REVLOOKUP 16

#define HL_SUBNET_CLASS_A 1
#define HL_SUBNET_CLASS_B 2
#define HL_SUBNET_CLASS_C 3

 struct host_in_loop{
	char * 	hostname; 	/* Name of the host, eg : 'www.server.com'	*/
	char *  hostip;		/* Ip of the host. eg : 145.309.0.30		*/
	struct in_addr addr;	/* addres			*/
	short 	id;		/* Internal ID number				*/
	short   trusted_by;	/* ID of the server that trust this one 	*/
	char 	tested;		/* tested ? 1 : yes ; 0 : no			*/
	struct fullresults_t * full_results;
	long	map_index;	/* For map drawing. Not used yet		*/
        int     alive;
	struct host_in_loop * next;	/* next host	*/
	};
	 
 struct hostlist_t{
	char * hostname;		/* Name of the host			*/
	struct in_addr  hostip;		/* ip of the host			*/
	struct hostlist_t * next;	/* Next host...				*/
	};
	
 struct domainlist_t {
 	char * domain;
 	struct domainlist_t * next;
 	};
        
  struct iplist_t {
 	struct in_addr ip;
 	struct iplist_t * next;
 	};
  
 	
struct hls_globals_t { 
 struct host_in_loop *hil;
 struct host_in_loop *c_hil;
 short num_hil;
 short cur_hil;
 int dns;
 int nfs;
 int ip;
 int ping;
 int revlookup;
 int subnet_class;
 struct domainlist_t * dml;
 struct iplist_t * subnets;
 };
 
#endif
