/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
 
#include <includes.h>
#include <gtk/gtk.h>
#include "xpm/HandOpen.xpm"
#include "xstuff.h"
#include "error_dialog.h"
#include "globals.h"

/* 
 * show_error
 *
 * This function draws a dialog showing an error
 *
 */
void 
show_error(error_text)
  char * error_text;
{
  GtkWidget * dialog;
  GtkWidget * button;
  GtkWidget * vbox;
  GtkWidget * hbox;
  GtkWidget * label;
  GtkStyle  * style;
  GtkWidget * pixmapwid;
  GdkPixmap * pixmap;
  GdkBitmap * mask;
  GtkWidget * table;
     
  dialog = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(dialog), "Error");
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL); 
  gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
  vbox = gtk_vbox_new(FALSE, 15);
  gtk_container_border_width(GTK_CONTAINER(dialog), 10);
  gtk_container_add(GTK_CONTAINER(dialog), vbox);
  gtk_widget_show(vbox);
  
  hbox = gtk_hbox_new(FALSE,5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE,0);
  gtk_widget_show(hbox);

  label = gtk_label_new(error_text);
  gtk_label_set_justify (GTK_LABEL(label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_end (GTK_BOX (hbox), label, TRUE, TRUE, 3);  
  gtk_widget_show(label);
 
  
  
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (close_window), dialog);
                      
  table = gtk_table_new(1,3, TRUE);
  gtk_box_pack_end(GTK_BOX(vbox), table, TRUE, TRUE, 0);
  gtk_widget_show(table);
  
  
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2,3,0,1);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button); 
  gtk_widget_realize(dialog);
 
  style = gtk_widget_get_style(dialog);
  if(F_show_pixmaps)
  {
   pixmap = gdk_pixmap_create_from_xpm_d(dialog->window, &mask,
					&style->bg[GTK_STATE_NORMAL],
					(char **)HandOpen_xpm);
   pixmapwid = gtk_pixmap_new(pixmap, mask);   
  
   gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, TRUE,3);
   gtk_widget_show(pixmapwid);
  }
  gtk_widget_show(dialog);
}                                

 
 
 
