/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#ifndef _NESSUSC_PREFS_HELP_H
#define _NESSUSC_PREFS_HELP_H

#define HLP_MISC_MAX_THREADS "Maximal of number of threads that the server will create \
for this test"

#define HLP_TEST_FILE "Name of the remote file that several plugins will attempt \
to read"

#define HLP_SCAN_OPT_PING "Shall the server performs an ICMP ECHO request before it \
attacks a host ? (beware : sometimes, remote hosts will not answer to those requests. \
The server needs to be uid root if you selected this option"

#define HLP_SCAN_OPT_REVERSE_LOOKUP "if this option is set, Nessus will only test the \
hosts the IP of which have a reverse lookup entry. ie : if the host 192.68.2.1 \
resolves, we will test it. If 192.68.2.16 doesn't, it won't be tested. This option \
is mainly useful when you allow the host expansion option 'subnet'"

#define HLP_SCAN_OPT_FIREWALL "Are the remote hosts protected by a firewall ? If so \
and if we are outside the firewall, it is a good idea to turn this option ON, so that \
Nessus will perform some additional tests to check that the remote firewall is well \
configured (this option is still experimental)"


#define HLP_SCAN_OPT_SCAN_LEVEL_NORMAL "Not implemented"
#define HLP_SCAN_OPT_SCAN_LEVEL_HEAVY "Not implemented"

#define HLP_SCAN_OPT_PORT_RANGE "Ports that will be scanned by Nessus. You can enter \
single ports, such as \"1-8000\" or more complex sets, such as\"21,23,25,1024-2048,6000\" \
Put \"-1\" for no portscan"


#define HLP_HOST_EXPANSION_DNS "Nessus will perform an AXFR request \
(that is, a zone transfer) to the remote name server and will attempt to obtain \
the list of the hosts of the remote domain. Then, it will test each host."

#define HLP_HOST_EXPANSION_NFS "Nessus will determine which hosts \
can mount the filesystems exported by the remote server, and will test them. \
Beware : this test is recursive"

#define HLP_HOST_EXPANSION_IP "Nessus will test the whole subnet \
of the remote host. If you select this option, you should allow Nessus to \
ping the hosts before scanning them in the 'Scan options' section"

#define HLP_HOST_EXPANSION_MAX_HOSTS "Maximal number of hosts to test. Set this \
to -1 if you do not want any limit"

#define HLP_TARGET_PRIMARY_TARGET "The first host(s) that will be attacked by Nessus. \
The options below allow you to extend the test to a larger set of computer. You may \
define several primary targets by separating them with a comma (,). ie : \"host1,host2\""

#define HLP_TARGET_SUBNET_CLASS_A "Set this if your subnet is a class A subnet (ie: your\
 netmask is something like 'x.255.255.255')"
 
#define HLP_TARGET_SUBNET_CLASS_B "Set this if your subnet is a class B subnet (ie: your\
 netmask is something like 'x.x.255.255')"

#define HLP_TARGET_SUBNET_CLASS_C "Set this if your subnet is a class C subnet (ie: your\
 netmask is something like 'x.x.x.255')"

#define HLP_USER_EMAIL "Set this to your email address. Some security checks will attempt\
 to send some files gathered on the victims"
 

#endif
