/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <includes.h>
#include <gtk/gtk.h>
#include "../xstuff.h"
#include "../preferences.h"
#include "prefs_dialog.h"
#include "../monitor_dialog.h"
#include "../error_dialog.h"

struct arglist * prefs_dialog_target(preferences)
 struct arglist * preferences;
{
 GtkWidget * frame;
 GtkWidget * table;
 GtkWidget * max_hosts;
 GtkWidget * label;
 GtkWidget * check_dns;
 GtkWidget * check_nfs;
 GtkWidget * check_subnets;
 GtkWidget * entry;
 GtkWidget * box;
 GtkWidget * radio;
 struct arglist *  ctrls = emalloc(sizeof(struct arglist));
 
 frame = gtk_frame_new("Target selection");
 gtk_container_border_width(GTK_CONTAINER(frame), 10);
 gtk_widget_show(frame);
 
 arg_add_value(ctrls,"PREFERENCES", ARG_PTR, -1, frame);
 arg_add_value(ctrls, "FRAME", ARG_PTR, -1, frame);
 
 
 table = gtk_table_new(5, 2, FALSE);
 gtk_container_add(GTK_CONTAINER(frame), table);
 gtk_container_border_width(GTK_CONTAINER(table), 10);
 gtk_table_set_row_spacings(GTK_TABLE(table), 5);
 gtk_widget_show(table);

 label = gtk_label_new("Primary target : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,0,1,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 entry = gtk_entry_new();
 gtk_table_attach(GTK_TABLE(table), entry, 1,2,0,1,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(entry);
 arg_add_value(ctrls, "TARGET", ARG_PTR, -1, entry);
 
 label = gtk_label_new("Max hosts : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,1,2,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 max_hosts = gtk_entry_new();
 arg_add_value(ctrls, "MAX_HOSTS", ARG_PTR, -1, max_hosts);
 gtk_table_attach(GTK_TABLE(table), max_hosts, 1,2,1,2,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(max_hosts);
 
 label = gtk_label_new("Host expansion : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,3,4,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 box = gtk_hbox_new(FALSE, 10);
 gtk_table_attach(GTK_TABLE(table), box, 1,2,3,4,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(box);
 
 check_dns = gtk_check_button_new_with_label("DNS");
 arg_add_value(ctrls, "DNS_EXPAND", ARG_PTR, -1, check_dns);
 gtk_box_pack_start(GTK_BOX(box), check_dns, FALSE, FALSE, 0);
 gtk_widget_show(check_dns);
 
 check_subnets = gtk_check_button_new_with_label("Subnets");
 arg_add_value(ctrls, "IP_EXPAND", ARG_PTR, -1, check_subnets);
 gtk_box_pack_start(GTK_BOX(box), check_subnets, FALSE, FALSE, 0);
 gtk_widget_show(check_subnets);
 
 check_nfs = gtk_check_button_new_with_label("NFS");
 arg_add_value(ctrls, "NFS_EXPAND", ARG_PTR, -1, check_nfs);
 gtk_box_pack_start(GTK_BOX(box), check_nfs, FALSE, FALSE, 0);
 gtk_widget_show(check_nfs);
 
 label = gtk_label_new("Subnet Class : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,4,5, GTK_FILL | GTK_EXPAND, 0,0,0);
 gtk_widget_show(label);
 
 box = gtk_hbox_new(FALSE, 10);
 gtk_table_attach(GTK_TABLE(table), box, 1,2,4,5, GTK_FILL | GTK_EXPAND, 0,0,0);
 gtk_widget_show(box);
 
 radio = gtk_radio_button_new_with_label(NULL, "A");
 gtk_box_pack_start(GTK_BOX(box), radio, FALSE, FALSE, 0);
 arg_add_value(ctrls, "CLASS_A", ARG_PTR, -1, radio);
 gtk_widget_show(radio);
 
 radio = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio)),
 					 "B");
 gtk_box_pack_start(GTK_BOX(box), radio, FALSE, FALSE, 0);
 arg_add_value(ctrls, "CLASS_B", ARG_PTR, -1, radio);
 gtk_widget_show(radio);
 
 
 radio = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio)),
 					 "C");
 gtk_box_pack_start(GTK_BOX(box), radio, FALSE, FALSE, 0);
 arg_add_value(ctrls, "CLASS_C", ARG_PTR, -1, radio);
 gtk_widget_show(radio);
 
 gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio), TRUE);
 
 return(ctrls);
}


